/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.engine;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.engine.AbstractAgentManager;
import melnorme.lang.ide.core.engine.ProjectReconcileManager;
import melnorme.lang.ide.core.engine.SourceModelManager;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.utils.CoreExecutors;
import melnorme.lang.ide.core.utils.DefaultBufferListener;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.utilbox.concurrency.ICommonExecutor;
import melnorme.utilbox.concurrency.ResultFuture;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.fntypes.CallableX;
import melnorme.utilbox.misc.Location;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISynchronizable;

public class DocumentReconcileManager
extends AbstractAgentManager {
    protected final ITextFileBufferManager fbm;
    protected final ProjectReconcileManager projectReconciler;

    public DocumentReconcileManager() {
        this(FileBuffers.getTextFileBufferManager(), LangCore.getBuildManager());
    }

    public DocumentReconcileManager(ITextFileBufferManager fbm, BuildManager buildMgr) {
        this.fbm = (ITextFileBufferManager)Assert.AssertNamespace.assertNotNull((Object)fbm);
        this.projectReconciler = (ProjectReconcileManager)Assert.AssertNamespace.assertNotNull((Object)new ProjectReconcileManager(this.executor, buildMgr));
    }

    @Override
    protected ICommonExecutor init_executor() {
        return CoreExecutors.newExecutorTaskAgent(DocumentReconcileManager.class);
    }

    @Override
    protected void dispose_post() {
        this.executor.shutdownNowAndCancelAll();
    }

    protected BuildManager getBuildManager() {
        return this.projectReconciler.buildMgr;
    }

    public DocumentReconcileConnection connectDocument(IDocument document, SourceModelManager.StructureInfo structureInfo) {
        ITextFileBuffer textFileBuffer;
        Location location = structureInfo.getLocation();
        ITextFileBuffer iTextFileBuffer = textFileBuffer = location == null ? null : ResourceUtils.getTextFileBuffer(this.fbm, location);
        if (textFileBuffer != null) {
            return new TextReconcileConnection(document, structureInfo, textFileBuffer);
        }
        return new DocumentReconcileConnection(document, structureInfo);
    }

    public static IProject getProject(IFileBuffer fileBuffer) {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)fileBuffer.getLocation(), (boolean)true);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R runUnderDocumentLock(IDocument doc, CallableX<R, RuntimeException> runnable) {
        ISynchronizable synchronizable;
        Object lockObject;
        if (doc instanceof ISynchronizable && (lockObject = (synchronizable = (ISynchronizable)doc).getLockObject()) != null) {
            Object object = lockObject;
            synchronized (object) {
                return (R)runnable.call();
            }
        }
        return (R)runnable.call();
    }

    public class DocumentReconcileConnection {
        protected final IDocument document;
        protected final SourceModelManager.StructureInfo structureInfo;
        protected final IDocumentListener docListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                Assert.AssertNamespace.assertTrue((DocumentReconcileConnection.this.document == event.fDocument ? 1 : 0) != 0);
                DocumentReconcileConnection.this.doDocumentChanged();
            }
        };

        public DocumentReconcileConnection(IDocument document, SourceModelManager.StructureInfo structureInfo) {
            this.document = (IDocument)Assert.AssertNamespace.assertNotNull((Object)document);
            this.structureInfo = (SourceModelManager.StructureInfo)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)structureInfo)));
            document.addDocumentListener(this.docListener);
        }

        public void disconnect() {
            this.document.removeDocumentListener(this.docListener);
        }

        protected SourceModelManager.StructureUpdateTask doDocumentChanged() {
            return this.structureInfo.queueSourceUpdateTask(this.document.get());
        }
    }

    public class TextReconcileConnection
    extends DocumentReconcileConnection {
        protected final IProject project;
        protected final ITextFileBuffer textFileBuffer;
        protected final DirtyBufferListener fbListener;
        protected ResultFuture.LatchFuture fileSaveFuture;

        public TextReconcileConnection(IDocument document, SourceModelManager.StructureInfo structureInfo, ITextFileBuffer textFileBuffer) {
            super(document, structureInfo);
            this.fileSaveFuture = new ResultFuture.LatchFuture();
            this.textFileBuffer = (ITextFileBuffer)Assert.AssertNamespace.assertNotNull((Object)textFileBuffer);
            this.fbListener = new DirtyBufferListener();
            DocumentReconcileManager.this.fbm.addFileBufferListener((IFileBufferListener)this.fbListener);
            this.project = DocumentReconcileManager.getProject((IFileBuffer)textFileBuffer);
        }

        @Override
        public void disconnect() {
            super.disconnect();
            DocumentReconcileManager.this.fbm.removeFileBufferListener((IFileBufferListener)this.fbListener);
            this.fileSaveFuture.cancel();
        }

        @Override
        protected SourceModelManager.StructureUpdateTask doDocumentChanged() {
            SourceModelManager.StructureUpdateTask structureUpdateTask = this.structureInfo.queueSourceUpdateTask(this.document.get());
            this.fileSaveFuture.cancel();
            this.fileSaveFuture = new ResultFuture.LatchFuture();
            if (this.project != null) {
                DocumentReconcileManager.this.projectReconciler.invalidateProjectModel(this.project, structureUpdateTask, this.fileSaveFuture);
            }
            return structureUpdateTask;
        }

        public class DirtyBufferListener
        extends DefaultBufferListener {
            @Override
            public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
                if (buffer == TextReconcileConnection.this.textFileBuffer && !isDirty) {
                    this.handleDocumentSaved();
                }
            }

            public boolean isUnderBuildAction() {
                StackTraceElement[] stackTrace;
                StackTraceElement[] stackTraceElementArray = stackTrace = new Exception().getStackTrace();
                int n = stackTrace.length;
                int n2 = 0;
                while (n2 < n) {
                    String className;
                    StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                    if (stackTraceElement.getMethodName().equals("run") && ((className = stackTraceElement.getClassName()).endsWith(".BuildAction") || className.endsWith(".GlobalBuildAction"))) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            protected void handleDocumentSaved() {
                if (!DocumentReconcileManager.this.getBuildManager().autoBuildsEnablement().isEnabled() || this.isUnderBuildAction()) {
                    ((TextReconcileConnection)TextReconcileConnection.this).DocumentReconcileManager.this.projectReconciler.cancelPendingReconciliation(TextReconcileConnection.this.project);
                    TextReconcileConnection.this.fileSaveFuture.setCompleted();
                    return;
                }
                TextReconcileConnection.this.fileSaveFuture.setCompleted();
                SourceModelManager.StructureUpdateTask structureUpdateTask = TextReconcileConnection.this.structureInfo.documentSaved(TextReconcileConnection.this.document);
                if (structureUpdateTask != null && TextReconcileConnection.this.project != null) {
                    ((TextReconcileConnection)TextReconcileConnection.this).DocumentReconcileManager.this.projectReconciler.invalidateProjectModel(TextReconcileConnection.this.project, structureUpdateTask, TextReconcileConnection.this.fileSaveFuture);
                }
            }
        }
    }
}

