/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.engine;

import java.util.HashMap;
import melnorme.lang.ide.core.engine.SourceModelManager;
import melnorme.lang.utils.concurrency.MonitorFutureTask;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.ICommonExecutor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.concurrency.ResultFuture;
import melnorme.utilbox.core.Assert;
import org.eclipse.core.resources.IProject;

abstract class AbstractProjectReconcileManager {
    protected final ICommonExecutor executor;
    protected final Object projectInfosLock = new Object();
    protected final HashMap<IProject, ProjectReconcileTask> projectInfos = new HashMap();

    public AbstractProjectReconcileManager(ICommonExecutor executor) {
        this.executor = (ICommonExecutor)Assert.AssertNamespace.assertNotNull((Object)executor);
    }

    public ICommonExecutor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateProjectModel(IProject project, SourceModelManager.StructureUpdateTask structureUpdateTask, ResultFuture.LatchFuture fileSaveFuture) {
        Assert.AssertNamespace.assertNotNull((Object)fileSaveFuture);
        Object object = this.projectInfosLock;
        synchronized (object) {
            ProjectReconcileTask currentReconcileTask = this.projectInfos.get(project);
            if (currentReconcileTask != null) {
                currentReconcileTask.cancel();
            }
            ProjectReconcileTask newReconcileTask = new ProjectReconcileTask(project, currentReconcileTask, structureUpdateTask, fileSaveFuture);
            this.projectInfos.put(project, newReconcileTask);
            this.getExecutor().submitTask(newReconcileTask.asFutureTask());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPendingReconciliation(IProject project) {
        Object object = this.projectInfosLock;
        synchronized (object) {
            ProjectReconcileTask currentReconcileTask = this.projectInfos.get(project);
            if (currentReconcileTask != null) {
                currentReconcileTask.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProjectInfo(ProjectReconcileTask projectReconcileTask) {
        Object object = this.projectInfosLock;
        synchronized (object) {
            this.projectInfos.remove(projectReconcileTask.project, (Object)projectReconcileTask);
        }
    }

    public abstract void doProjectReconcile(IProject var1, ICancelMonitor var2);

    public class ProjectReconcileTask
    extends MonitorFutureTask<RuntimeException> {
        protected final IProject project;
        protected final ProjectReconcileTask previousReconcileTask;
        protected final SourceModelManager.StructureUpdateTask structureUpdateTask;
        protected final ResultFuture.LatchFuture fileSaveFuture;

        public ProjectReconcileTask(IProject project, ProjectReconcileTask previousReconcileTask, SourceModelManager.StructureUpdateTask structureUpdateTask, ResultFuture.LatchFuture fileSaveFuture) {
            this.project = (IProject)Assert.AssertNamespace.assertNotNull((Object)project);
            this.previousReconcileTask = previousReconcileTask;
            this.structureUpdateTask = (SourceModelManager.StructureUpdateTask)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)structureUpdateTask)));
            this.fileSaveFuture = (ResultFuture.LatchFuture)Assert.AssertNamespace.assertNotNull((Object)fileSaveFuture);
        }

        public void awaitPreconditions() throws OperationCancellation, InterruptedException {
            this.fileSaveFuture.awaitResult();
            if (this.structureUpdateTask != null) {
                this.structureUpdateTask.structureInfo.awaitUpdatedData();
            }
        }

        protected void runTask() {
            try {
                try {
                    if (this.previousReconcileTask != null) {
                        this.previousReconcileTask.awaitPreconditions();
                    }
                }
                catch (OperationCancellation operationCancellation) {
                    // empty catch block
                }
                this.awaitPreconditions();
            }
            catch (InterruptedException | OperationCancellation e) {
                return;
            }
            if (this.cancelMonitor.isCanceled()) {
                return;
            }
            AbstractProjectReconcileManager.this.doProjectReconcile(this.project, (ICancelMonitor)this.cancelMonitor);
            AbstractProjectReconcileManager.this.removeProjectInfo(this);
        }
    }
}

