/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core;

import melnorme.lang.ide.core.LangCore;
import melnorme.utilbox.misc.ArrayUtil;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class LangNature
implements IProjectNature {
    public static final String NATURE_ID = "com.googlecode.goclipse.core.goNature";
    protected IProject project;

    public void setProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public void configure() throws CoreException {
        this.addToBuildSpec(this.getBuilderId());
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec(this.getBuilderId());
    }

    protected abstract String getBuilderId();

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        Object[] commands = description.getBuildSpec();
        int commandIndex = LangNature.getCommandIndex((ICommand[])commands, builderID);
        if (commandIndex == -1) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            command.setBuilding(9, false);
            ICommand[] newCommands = (ICommand[])ArrayUtil.prepend((Object)command, (Object[])commands);
            description.setBuildSpec(newCommands);
            this.project.setDescription(description, null);
        }
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        Object[] commands = description.getBuildSpec();
        int commandIndex = LangNature.getCommandIndex((ICommand[])commands, builderID);
        if (commandIndex != -1) {
            commands = (ICommand[])ArrayUtil.removeAt((Object[])commands, (int)commandIndex);
            description.setBuildSpec((ICommand[])commands);
            this.project.setDescription(description, null);
        }
    }

    public static void disableAutoBuildMode(IProject project, String builderId, IProgressMonitor monitor) throws CoreException {
        ICommand[] buildSpec;
        IProjectDescription description = project.getDescription();
        ICommand[] iCommandArray = buildSpec = description.getBuildSpec();
        int n = buildSpec.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals(builderId)) {
                command.setBuilding(9, false);
            }
            ++n2;
        }
        description.setBuildSpec(buildSpec);
        project.setDescription(description, 64, monitor);
    }

    protected static int getCommandIndex(ICommand[] buildSpec, String builderID) {
        int i = 0;
        while (i < buildSpec.length) {
            if (buildSpec[i].getBuilderName().equals(builderID)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isAccessible(IProject project) throws CoreException {
        return project.isAccessible() && project.hasNature(NATURE_ID);
    }

    public static boolean isAccessible(IProject project, boolean logOnError) {
        try {
            return project.isAccessible() && project.hasNature(NATURE_ID);
        }
        catch (CoreException e) {
            if (logOnError) {
                LangCore.logError("Error trying to determine project nature.", e);
            }
            return false;
        }
    }
}

