/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core;

import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.utilbox.misc.ILogHandler;
import melnorme.utilbox.status.IStatusMessage;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public abstract class LangCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.googlecode.goclipse.core";
    public static final String TESTS_PLUGIN_ID = "com.googlecode.goclipse.core.tests";
    public static final String NATURE_ID = "com.googlecode.goclipse.core.goNature";
    protected static LangCorePlugin pluginInstance;
    public static final ILogHandler LOG_HANDLER;
    protected LangCore langCore;
    protected boolean initializedAfterUI = false;

    static {
        LOG_HANDLER = new ILogHandler(){

            public void logStatus(StatusException se) {
                int severity = EclipseUtils.toEclipseSeverity((IStatusMessage)se);
                ILog log = LangCorePlugin.getInstance().getLog();
                log.log((IStatus)EclipseCore.createStatus(severity, se.getMessage(), se.getCause()));
            }
        };
    }

    public static LangCorePlugin getInstance() {
        return pluginInstance;
    }

    public final void start(BundleContext context) throws Exception {
        pluginInstance = this;
        this.langCore = new LangCore(LOG_HANDLER);
        super.start(context);
        this.doCustomStart(context);
    }

    protected abstract void doCustomStart(BundleContext var1);

    public final void initializeAfterUIStart() {
        if (this.initializedAfterUI) {
            LangCore.logWarning("Atempted initializeAfterUIStart more than once.");
        } else {
            this.initializedAfterUI = true;
            this.langCore.startAgentsAfterUIStart();
        }
    }

    public final void stop(BundleContext context) throws Exception {
        this.doCustomStop(context);
        this.langCore.shutdown();
        super.stop(context);
        pluginInstance = null;
    }

    protected abstract void doCustomStop(BundleContext var1);
}

