/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.core.tools;

import java.util.List;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.operations.ToolchainPreferences;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.ownership.IDisposable;
import melnorme.utilbox.process.ExternalProcessNotifyingHelper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;

public class GocodeServerManager
implements IDisposable {
    protected final ToolManager toolMgr = LangCore.getToolManager();
    protected ExternalProcessNotifyingHelper gocodeProcess;

    public IPath getGocodePath() {
        String pref = (String)ToolchainPreferences.DAEMON_PATH.get();
        if (pref == null || pref.length() == 0) {
            return null;
        }
        return new Path(pref);
    }

    protected boolean isChildServerRunning() {
        return this.gocodeProcess != null;
    }

    public boolean prepareServerStart() throws CommonException {
        IPath gocodePath = this.getGocodePath();
        if (gocodePath == null || gocodePath.isEmpty()) {
            throw new CommonException("No gocode path provided.", null);
        }
        return this.gocodeProcess == null;
    }

    public void doStartServer(IOperationMonitor monitor) throws CommonException, OperationCancellation {
        IPath gocodePath = this.getGocodePath();
        ArrayList2 commandLine = new ArrayList2();
        commandLine.add((Object)gocodePath.toOSString());
        commandLine.add((Object)"-s");
        commandLine.add((Object)"-sock=tcp");
        LangCore.logInfo("Starting gocode server: " + DebugPlugin.renderArguments((String[])((String[])commandLine.toArray(String.class)), null));
        ProcessBuilder pb = new ProcessBuilder((List<String>)commandLine);
        ILangOperationsListener_Default.IToolOperationMonitor opMonitor = this.toolMgr.startNewOperation(ILangOperationsListener_Default.ProcessStartKind.ENGINE_SERVER, true, false);
        String prefixText = "==== Starting gocode server ====\n";
        this.gocodeSetEnableBuiltins(gocodePath, monitor, opMonitor, prefixText);
        ToolManager toolManager = this.toolMgr;
        ((Object)((Object)toolManager)).getClass();
        this.gocodeProcess = new ToolManager.RunToolTask(toolManager, opMonitor, prefixText, pb, (ICancelMonitor)monitor).startProcess();
    }

    protected void gocodeSetEnableBuiltins(IPath gocodePath, IOperationMonitor om, ILangOperationsListener_Default.IToolOperationMonitor toolOpMonitor, String prefixText) throws CommonException, OperationCancellation {
        ProcessBuilder pb = new ProcessBuilder(gocodePath.toString(), "set", "propose-builtins", "true");
        ToolManager toolManager = this.toolMgr;
        ((Object)((Object)toolManager)).getClass();
        new ToolManager.RunToolTask(toolManager, toolOpMonitor, prefixText, pb, (ICancelMonitor)om).runProcess();
    }

    public void stopServer() {
        if (this.gocodeProcess != null) {
            LangCore.logInfo("stopping gocode server");
            this.gocodeProcess.getProcess().destroy();
            this.gocodeProcess = null;
        }
    }

    public void dispose() {
        this.stopServer();
    }
}

