/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.core.operations;

import com.googlecode.goclipse.core.GoCoreMessages;
import com.googlecode.goclipse.core.GoProjectEnvironment;
import com.googlecode.goclipse.tooling.GoBuildOutputProcessor;
import com.googlecode.goclipse.tooling.GoPackageName;
import com.googlecode.goclipse.tooling.env.CheckSrcFolderRootFilesWithNoPackage;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import com.googlecode.goclipse.tooling.env.GoWorkspaceLocation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.operations.ToolMarkersHelper;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildOperationCreator;
import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.ide.core.operations.build.BuildTargetOperation;
import melnorme.lang.ide.core.project_model.LangBundleModel;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.tooling.bundle.BuildConfiguration;
import melnorme.lang.tooling.bundle.BuildTargetNameParser;
import melnorme.lang.tooling.bundle.BuildTargetNameParser2;
import melnorme.lang.tooling.bundle.BundleInfo;
import melnorme.lang.tooling.bundle.LaunchArtifact;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;
import melnorme.utilbox.misc.PathUtil;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.process.ExternalProcessHelper;
import melnorme.utilbox.status.StatusLevel;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugPlugin;

public class GoBuildManager
extends BuildManager {
    public static final String BUILD_TYPE_Build = "build";
    public static final String BUILD_TYPE_BuildTests = "build-tests";
    public static final String BUILD_TYPE_Lint = "lint";
    public static final String BUILD_TYPE_RunTests = "[run-tests]";
    public static final Indexable<BuildManager.BuildType> BUILD_TYPES = GoBuildManager.createDefaultBuildTypes();
    public static final Indexable<String> BUILD_TYPES_Names = BUILD_TYPES.map(buildType -> buildType.getName());

    public GoBuildManager(LangBundleModel bundleModel, ToolManager toolManager) {
        super(bundleModel, toolManager);
    }

    public static ArrayList2<BuildManager.BuildType> createDefaultBuildTypes() {
        return ArrayList2.create((Object[])new BuildManager.BuildType[]{new GoDefaultBuildType(BUILD_TYPE_Build), new GoTestBuildType(), new GoLintBuildType(), new GoRunTestsBuildType()});
    }

    @Override
    protected Indexable<BuildManager.BuildType> getBuildTypes_do() {
        return BUILD_TYPES;
    }

    @Override
    public BuildTargetNameParser getBuildTargetNameParser() {
        return new BuildTargetNameParser2();
    }

    @Override
    protected void addDefaultBuildTarget(ArrayList2<BuildTarget> buildTargets, IProject project, BundleInfo bundleInfo, BuildConfiguration buildConfig, BuildManager.BuildType buildType, BuildTargetData btd) {
        super.addDefaultBuildTarget(buildTargets, project, bundleInfo, buildConfig, buildType, btd);
    }

    protected static GoEnvironment getValidGoEnvironment(IProject project) throws CommonException {
        return GoProjectEnvironment.getValidatedGoEnvironment(project);
    }

    protected static void addSourcePackagesToCmdLine(IProject project, ArrayList2<String> goBuildCmdLine, GoEnvironment goEnvironment) throws CommonException {
        ArrayList2<GoPackageName> sourcePackages = GoProjectEnvironment.findSourcePackages(project, goEnvironment);
        for (GoPackageName goPackageName : sourcePackages) {
            goBuildCmdLine.add((Object)goPackageName.getFullNameAsString());
        }
    }

    @Override
    protected BuildOperationCreator createBuildOperationCreator(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, IProject project) {
        return new BuildOperationCreator(project, opMonitor){

            @Override
            protected void addCompositeBuildOperationMessage() throws CommonException {
                super.addCompositeBuildOperationMessage();
                GoEnvironment goEnv = GoProjectEnvironment.getGoEnvironment(this.project);
                this.addOperation(this.newMessageOperation("  with GOPATH: " + goEnv.getGoPathString() + "\n"));
            }
        };
    }

    public static abstract class AbstractGoBuildType
    extends BuildManager.BuildType {
        public AbstractGoBuildType(String name) {
            super(name);
        }

        @Override
        protected BuildConfiguration getValidBuildconfiguration(String buildConfigName, BundleInfo bundleInfo) throws CommonException {
            return new BuildConfiguration(buildConfigName, null);
        }

        protected GoPackageName getValidGoPackageName(String goPackageString) throws CommonException {
            return GoPackageName.createValid((String)goPackageString);
        }

        @Override
        public String getDefaultCommandArguments(BuildTarget bt) throws CommonException {
            ArrayList2<String> buildArgs = this.getDefaultCommandArguments_list(bt);
            return DebugPlugin.renderArguments((String[])((String[])buildArgs.toArray(String.class)), null);
        }

        protected ArrayList2<String> getDefaultCommandArguments_list(BuildTarget bt) throws CommonException {
            Indexable<String> baseCommand = this.getBuildCommand2();
            ArrayList2 commandLine = baseCommand.toArrayList().addElements((Object[])new String[]{"-v", "-gcflags", "-N -l"});
            this.addPackageSpecCommand(bt, (ArrayList2<String>)commandLine);
            return commandLine;
        }

        protected void addPackageSpecCommand(BuildTarget bt, ArrayList2<String> buildCommand) throws CommonException {
            String goPackageSpec = this.getGoPackageSpec(bt.getProject(), bt.getBuildConfigName());
            buildCommand.addElements((Object[])new String[]{goPackageSpec});
        }

        protected abstract Indexable<String> getBuildCommand2();

        protected String getGoPackageSpec(IProject project, String goPackageSpec) throws CommonException {
            if (goPackageSpec == null || goPackageSpec.isEmpty()) {
                GoEnvironment goEnv = GoProjectEnvironment.getGoEnvironment(project);
                GoPackageName goPackage = goEnv.getGoPath().findGoPackageForLocation(ResourceUtils.loc(project.getLocation()));
                goPackageSpec = goPackage != null ? goPackage.toString() : ".";
                goPackageSpec = String.valueOf(goPackageSpec) + "/...";
            }
            return goPackageSpec;
        }

        @Override
        public LaunchArtifact getMainLaunchArtifact(BuildTarget bt) throws CommonException {
            try {
                String buildConfigName = bt.getBuildConfigName();
                Path path = PathUtil.createPath((String)buildConfigName);
                if (path.getNameCount() == 0 || path.endsWith("...")) {
                    return null;
                }
            }
            catch (CommonException e) {
                return null;
            }
            Location binFolderLocation = GoProjectEnvironment.getBinFolderLocation(bt.getProject());
            String binFilePath = this.getBinFilePath(this.getValidGoPackageName(bt.getBuildConfigName()));
            String exePath = binFolderLocation.resolve(String.valueOf(binFilePath) + MiscUtil.getExecutableSuffix()).toString();
            return new LaunchArtifact(bt.getBuildConfigName(), exePath);
        }

        protected Location getBinFolderLocation(BuildTarget buildTarget) throws CommonException {
            return GoProjectEnvironment.getBinFolderLocation(buildTarget.getProject());
        }

        protected String getBinFilePath(GoPackageName goPackageName) throws CommonException {
            return goPackageName.getLastSegment();
        }
    }

    public static class GoBuildTargetOperation
    extends BuildTargetOperation {
        protected final GoEnvironment goEnv;
        protected final Location sourceBaseDir;
        protected Location workingDirectory;

        public GoBuildTargetOperation(BuildTargetOperation.BuildOperationParameters buildOpParams) throws CommonException {
            super(buildOpParams);
            Location projectLoc = this.getProjectLocation();
            this.goEnv = GoProjectEnvironment.getValidatedGoEnvironment(this.project);
            this.sourceBaseDir = this.goEnv.getGoPath().getSourceRootforLocation(projectLoc);
            if (this.sourceBaseDir == null) {
                throw new CommonException(GoCoreMessages.ERROR_GOPATH_DoesNotContainProject());
            }
            if (this.sourceBaseDir.getParent().equals((Object)projectLoc)) {
                this.checkForGoFilesInSourceRoot(this.sourceBaseDir);
            }
            this.workingDirectory = this.sourceBaseDir;
        }

        @Override
        public ProcessBuilder getToolProcessBuilder() throws CommonException, OperationCancellation {
            ProcessBuilder pb = super.getToolProcessBuilder();
            if (this.workingDirectory != null) {
                pb.directory(this.workingDirectory.toFile());
            }
            this.goEnv.setupProcessEnv(pb, true);
            return pb;
        }

        protected void checkForGoFilesInSourceRoot(Location sourceBaseDir) throws CommonException {
            CheckSrcFolderRootFilesWithNoPackage srcCheck = new CheckSrcFolderRootFilesWithNoPackage();
            if (!sourceBaseDir.toFile().exists()) {
                throw new CommonException(GoCoreMessages.ERROR_ProjectDoesNotHaveSrcFolder(sourceBaseDir.getParent()));
            }
            srcCheck.checkDir(sourceBaseDir);
            if (srcCheck.containsGoSources) {
                LangCore.getToolManager().notifyMessage(StatusLevel.WARNING, "Go build: Warning!", GoCoreMessages.ERROR_SrcRootContainsGoFiles(sourceBaseDir));
            }
        }

        @Override
        protected void processBuildOutput(ExternalProcessHelper.ExternalProcessResult buildAllResult, IOperationMonitor om) throws CommonException, OperationCancellation {
            GoBuildOutputProcessor buildOutput = new GoBuildOutputProcessor(){

                protected void handleParseError(CommonException ce) {
                    LangCore.logError(ce.getMessage(), ce.getCause());
                }
            };
            ArrayList buildMessages = buildOutput.doParseResult(buildAllResult);
            new ToolMarkersHelper(true).addErrorMarkers(buildMessages, this.workingDirectory, om);
        }
    }

    public static class GoDefaultBuildType
    extends AbstractGoBuildType {
        public GoDefaultBuildType(String name) {
            super(name);
        }

        @Override
        protected Indexable<String> getBuildCommand2() {
            return CoreUtil.list((Object[])new String[]{"install"});
        }

        @Override
        public BuildTargetOperation getBuildOperation(BuildTargetOperation.BuildOperationParameters buildOpParams) throws CommonException {
            return new GoBuildTargetOperation(buildOpParams);
        }
    }

    public static class GoLintBuildType
    extends GoDefaultBuildType {
        public GoLintBuildType() {
            super(GoBuildManager.BUILD_TYPE_Lint);
        }

        @Override
        public String getDefaultCommandLine(BuildTarget bt) throws CommonException {
            return this.getDefaultCommandArguments(bt);
        }

        @Override
        protected ArrayList2<String> getDefaultCommandArguments_list(BuildTarget bt) throws CommonException {
            ArrayList2 commandLine = new ArrayList2((Object[])new String[]{"gometalinter", "-t"});
            this.addPackageSpecCommand(bt, (ArrayList2<String>)commandLine);
            return commandLine;
        }
    }

    public static class GoRunTestsBuildType
    extends AbstractGoBuildType {
        public GoRunTestsBuildType() {
            super(GoBuildManager.BUILD_TYPE_RunTests);
        }

        @Override
        protected Indexable<String> getBuildCommand2() {
            return CoreUtil.list((Object[])new String[]{"test"});
        }

        @Override
        public LaunchArtifact getMainLaunchArtifact(BuildTarget bt) throws CommonException {
            return null;
        }

        @Override
        public BuildTargetOperation getBuildOperation(BuildTargetOperation.BuildOperationParameters buildOpParams) throws CommonException {
            return new GoBuildTargetOperation(buildOpParams);
        }
    }

    public static class GoTestBuildType
    extends AbstractGoBuildType {
        public GoTestBuildType() {
            super(GoBuildManager.BUILD_TYPE_BuildTests);
        }

        @Override
        protected Indexable<String> getBuildCommand2() {
            return CoreUtil.list((Object[])new String[]{"test", "-c"});
        }

        @Override
        protected String getBinFilePath(GoPackageName goPackageName) throws CommonException {
            if (this.isMultipleGoPackages(goPackageName.getFullNameAsString())) {
                throw new CommonException("Cannot use multiple packages spec `...` when building for a launch.");
            }
            return String.valueOf(super.getBinFilePath(goPackageName)) + ".test";
        }

        protected boolean isMultipleGoPackages(String goPackageName) {
            return goPackageName.endsWith("/...") || goPackageName.equals("...");
        }

        protected boolean isMultipleGoPackagesCommandInvocation(Indexable<String> commandLine) {
            if (commandLine.size() <= 1) {
                return false;
            }
            String lastArg = (String)commandLine.get(commandLine.size() - 1);
            return this.isMultipleGoPackages(lastArg);
        }

        @Override
        public BuildTargetOperation getBuildOperation(BuildTargetOperation.BuildOperationParameters buildOpParams) throws CommonException {
            return new GoBuildTargetOperation(buildOpParams){
                {
                    super($anonymous0);
                    this.workingDirectory = GoProjectEnvironment.getBinFolderLocation(this.project);
                }

                @Override
                public void execute(IOperationMonitor om) throws CommonException, OperationCancellation {
                    ArrayList2 commandLineOriginal = new ArrayList2(this.getEffectiveProccessCommandLine());
                    ProcessBuilder pb = this.getToolProcessBuilder();
                    if (!this.isMultipleGoPackagesCommandInvocation((Indexable<String>)commandLineOriginal)) {
                        this.runBuildToolAndProcessOutput(pb, om);
                        return;
                    }
                    ArrayList2 argumentsTemplate = new ArrayList2((Collection2)commandLineOriginal);
                    int lastArgIx = commandLineOriginal.size() - 1;
                    String goPackageToBuild = StringUtil.trimEnd((String)((String)argumentsTemplate.get(lastArgIx)), (String)"...");
                    GoWorkspaceLocation goWorkspace = this.goEnv.getGoPath().findGoPathEntry(this.getProjectLocation());
                    ArrayList2 sourcePackages = goWorkspace.findSubPackages(goPackageToBuild);
                    for (GoPackageName goPackage : sourcePackages) {
                        argumentsTemplate.set(lastArgIx, (Object)goPackage.getFullNameAsString());
                        pb.command((List<String>)argumentsTemplate);
                        this.runBuildToolAndProcessOutput(pb, om);
                    }
                }
            };
        }
    }
}

