/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.core.operations;

import com.googlecode.goclipse.tooling.env.GoEnvironment;
import com.googlecode.goclipse.tooling.env.GoPath;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.CollectionUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;

public class GetAndInstallGoPackageOperation {
    protected final ToolManager toolMgr = LangCore.getToolManager();
    protected final GoEnvironment goEnv;
    protected final String goPackage;
    protected final String exeName;
    protected boolean preventWindowsConsoleGUI = false;
    protected Location workingDir;

    public GetAndInstallGoPackageOperation(GoEnvironment goEnv, String goPackage, String exeName) {
        this.goEnv = (GoEnvironment)Assert.AssertNamespace.assertNotNull((Object)goEnv);
        this.goPackage = (String)Assert.AssertNamespace.assertNotNull((Object)goPackage);
        this.exeName = (String)Assert.AssertNamespace.assertNotNull((Object)exeName);
    }

    public ProcessBuilder getProcessToStart() throws CommonException {
        this.workingDir = this.getFirstGoPathEntry(this.goEnv);
        ArrayList2<String> cmdLine = this.getCmdLine();
        return this.goEnv.createProcessBuilder(cmdLine, this.workingDir, true);
    }

    protected Location getFirstGoPathEntry(GoEnvironment goEnv) throws CommonException {
        GoPath goPath = goEnv.getGoPath();
        if (goPath.isEmpty()) {
            throw new CommonException("GOPATH is empty, can't install.");
        }
        String workingDirStr = (String)goPath.getGoPathEntries().get(0);
        Location workingDir = Location.createValidLocation((String)workingDirStr, (String)"Invalid GOPATH: ");
        return workingDir;
    }

    public ArrayList2<String> getCmdLine() throws CommonException {
        String sdkPath = this.toolMgr.getSDKToolPath(null).toString();
        ArrayList2 cmdLine = CollectionUtil.createArrayList((Object[])new String[]{sdkPath, "get", "-u"});
        if (this.preventWindowsConsoleGUI && MiscUtil.OS_IS_WINDOWS) {
            cmdLine.addElements((Object[])new String[]{"-ldflags", "-H=windowsgui"});
        }
        cmdLine.addElements((Object[])new String[]{this.goPackage});
        return cmdLine;
    }

    public Location getDownloadedToolLocation() {
        return this.workingDir.resolve_fromValid("bin/" + this.exeName + (MiscUtil.OS_IS_WINDOWS ? ".exe" : ""));
    }
}

