/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.core.engine;

import com.googlecode.goclipse.core.GoProjectEnvironment;
import com.googlecode.goclipse.core.GoToolPreferences;
import com.googlecode.goclipse.tooling.GoSourceFileUtil;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import com.googlecode.goclipse.tooling.env.GoPath;
import com.googlecode.goclipse.tooling.oracle.GuruDescribeOperation;
import com.googlecode.goclipse.tooling.oracle.GuruPackageDescribeParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.engine.SourceModelManager;
import melnorme.lang.tooling.structure.SourceFileStructure;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.FileUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.process.ExternalProcessHelper;

public class GoSourceModelManager
extends SourceModelManager {
    @Override
    protected SourceModelManager.StructureUpdateTask createUpdateTask(SourceModelManager.StructureInfo structureInfo, String source) {
        return this.createUpdateTask(structureInfo, source, false);
    }

    @Override
    protected SourceModelManager.StructureUpdateTask createUpdateTask_forFileSave(SourceModelManager.StructureInfo structureInfo, String source) {
        return this.createUpdateTask(structureInfo, source, true);
    }

    protected SourceModelManager.StructureUpdateTask createUpdateTask(SourceModelManager.StructureInfo structureInfo, String source, boolean isSavedToDisk) {
        Location fileLocation = structureInfo.getLocation();
        if (fileLocation == null) {
            return new StructureUpdateNullTask(structureInfo);
        }
        return new GoStructureUpdateTask(structureInfo, source, fileLocation, isSavedToDisk);
    }

    protected class GoStructureUpdateTask
    extends SourceModelManager.StructureUpdateTask {
        protected final String source;
        protected final Location fileLocation;
        protected final boolean isDocumentSavedToDisk;
        protected Location tempDir;
        protected GoEnvironment goEnv;
        protected Location describeFile;

        public GoStructureUpdateTask(SourceModelManager.StructureInfo structureInfo, String source, Location fileLocation, boolean isSavedToDisk) {
            super(structureInfo);
            this.source = source;
            this.fileLocation = fileLocation;
            this.isDocumentSavedToDisk = isSavedToDisk;
        }

        @Override
        protected SourceFileStructure doCreateNewData() throws CommonException, OperationCancellation {
            ExternalProcessHelper.ExternalProcessResult describeResult;
            if (this.fileLocation == null || this.isCancelled()) {
                return null;
            }
            this.goEnv = GoProjectEnvironment.getGoEnvironmentFromLocation(this.fileLocation);
            this.describeFile = this.fileLocation;
            this.tempDir = null;
            try {
                this.setupDescribeFile();
            }
            catch (IOException e) {
                throw new CommonException("Error creating temporary file for `guru describe`: ", (Throwable)e);
            }
            try {
                try {
                    describeResult = this.runGuru(this.goEnv, this.describeFile);
                }
                catch (CommonException e) {
                    throw new CommonException("Error running `guru describe` for source structure update: ", (Throwable)e);
                }
            }
            finally {
                if (this.tempDir != null) {
                    try {
                        FileUtil.deleteDir((Location)this.tempDir);
                    }
                    catch (IOException e) {
                        LangCore.logError("Could not delete temp files", e);
                    }
                }
            }
            if (this.fileLocation == null || this.isCancelled()) {
                return null;
            }
            try {
                return new GuruPackageDescribeParser(this.fileLocation, this.source){

                    protected boolean isSourceElementLocation(Location sourceFileLoc) throws CommonException {
                        return GoStructureUpdateTask.this.describeFile.equals((Object)sourceFileLoc);
                    }
                }.parse(describeResult);
            }
            catch (CommonException e) {
                throw new CommonException("Error parsing `guru describe` result, for source structure update: ", (Throwable)e);
            }
        }

        protected void setupDescribeFile() throws IOException, FileNotFoundException {
            if (this.isDocumentSavedToDisk) {
                return;
            }
            this.tempDir = Location.create_fromValid((Path)Files.createTempDirectory("_goclipse", new FileAttribute[0]));
            Location tempDir_src = this.tempDir.resolve_fromValid("src/describe_temp");
            Files.createDirectories(tempDir_src.toPath(), new FileAttribute[0]);
            this.describeFile = tempDir_src.resolve_fromValid("describe.go");
            FileUtil.writeStringToFile((File)this.describeFile.toFile(), (String)this.source, (Charset)StringUtil.UTF8);
            this.goEnv = new GoEnvironment(this.goEnv.getGoRoot(), new GoPath(this.tempDir.toString()));
        }

        protected ExternalProcessHelper.ExternalProcessResult runGuru(GoEnvironment goEnv, Location opTempFile) throws CommonException, OperationCancellation {
            GuruDescribeOperation guruOp = new GuruDescribeOperation(GoToolPreferences.GO_GURU_Path.getDerivedValue().toString());
            int offset = GoSourceFileUtil.findPackageDeclaration_NameStart((String)this.source);
            ProcessBuilder pb = guruOp.createProcessBuilder(goEnv, opTempFile, offset);
            return LangCore.getToolManager().runEngineTool(pb, null, this.cm);
        }
    }

    public static class StructureUpdateNullTask
    extends SourceModelManager.StructureUpdateTask {
        public StructureUpdateNullTask(SourceModelManager.StructureInfo structureInfo) {
            super(structureInfo);
        }

        @Override
        protected SourceFileStructure doCreateNewData() {
            return null;
        }
    }
}

