/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.jface.resources;

import melnorme.lang.ide.core.LangCore;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public abstract class CompositeImageDescriptorExt
extends CompositeImageDescriptor {
    protected final ImageDescriptor baseImage;
    protected int xOffset;
    protected int yOffset;

    public CompositeImageDescriptorExt(ImageDescriptor baseImage) {
        this.baseImage = (ImageDescriptor)Assert.AssertNamespace.assertNotNull((Object)baseImage);
    }

    protected ImageData getImageData(ImageDescriptor desc) {
        ImageData imageData = desc.getImageData();
        if (imageData == null) {
            LangCore.logError((String)"Could not get ImageData.");
            return new ImageData(1, 1, 32, CompositeImageDescriptorExt.DEFAULT_IMAGE_DATA.palette);
        }
        return imageData;
    }

    public void resetDrawPosition(Corner corner) {
        switch (corner) {
            case TOP_LEFT: {
                this.xOffset = 0;
                this.yOffset = 0;
                return;
            }
            case TOP_RIGHT: {
                this.xOffset = this.getSize().x;
                this.yOffset = 0;
                return;
            }
            case BOTTOM_LEFT: {
                this.xOffset = 0;
                this.yOffset = this.getSize().y;
                return;
            }
            case BOTTOM_RIGHT: {
                this.xOffset = this.getSize().x;
                this.yOffset = this.getSize().y;
                return;
            }
        }
        throw Assert.AssertNamespace.assertUnreachable();
    }

    public void drawOverlayAtCorner(ImageDescriptor overlayImage, Corner corner) {
        this.resetDrawPosition(corner);
        this.drawOverlayAtCursor(overlayImage, corner);
    }

    protected void drawOverlayAtCursor(ImageDescriptor overlayImage, Corner corner) {
        ImageData imageData = this.getImageData(overlayImage);
        if (corner.isRight()) {
            this.xOffset -= imageData.width;
        }
        int ypos = corner.isTop() ? this.yOffset : this.yOffset - imageData.height;
        this.drawImage(imageData, this.xOffset, ypos);
        if (corner.isLeft()) {
            this.xOffset += imageData.width;
        }
    }

    protected void drawImageSequence(Indexable<ImageDescriptor> images, Corner corner, int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        for (ImageDescriptor desc : images) {
            this.drawOverlayAtCursor(desc, corner);
        }
    }

    public static enum Corner {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;


        public boolean isTop() {
            return this == TOP_LEFT || this == TOP_RIGHT;
        }

        public boolean isBottom() {
            return !this.isTop();
        }

        public boolean isLeft() {
            return this == TOP_LEFT || this == BOTTOM_LEFT;
        }

        public boolean isRight() {
            return !this.isLeft();
        }
    }

    public static enum HorizontalDirection {
        LEFT,
        RIGHT;

    }

    public static enum VerticalDirection {
        TOP,
        BOTTOM;

    }
}

