/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components.fields;

import melnorme.util.swt.SWTLayoutUtil;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.LabelledFieldWidget;
import melnorme.utilbox.fields.Field;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextFieldWidget
extends LabelledFieldWidget<String> {
    protected int defaultTextStyle = 2052;
    protected Text text;

    public TextFieldWidget(String label) {
        this(label, 2052);
    }

    public TextFieldWidget(String label, int textStyle) {
        super(label, LabelledFieldWidget.Option_AllowNull.NO, "");
        this.defaultTextStyle = textStyle;
    }

    public TextFieldWidget(Field<String> field, String label) {
        super(field, label);
    }

    public void setDefaultTextStyle(int defaultTextStyle) {
        this.defaultTextStyle = defaultTextStyle;
    }

    public void setMultiLineStyle() {
        this.defaultTextStyle |= 2;
        this.defaultTextStyle &= 0xFFFFFFFB;
    }

    @Override
    public int getPreferredLayoutColumns() {
        return 2;
    }

    @Override
    protected void createContents_all(Composite topControl) {
        this.createContents_Label(topControl);
        this.createContents_Text(topControl);
    }

    @Override
    protected void createContents_layout() {
        SWTLayoutUtil.layout2Controls_expandLast((Control)this.label, (Control)this.text);
    }

    protected void createContents_Text(Composite topControl) {
        this.text = this.createText(topControl);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TextFieldWidget.this.setFieldValueFromControl(TextFieldWidget.this.text.getText());
                TextFieldWidget.this.handleFieldValueAndControlChanged();
            }
        });
    }

    protected Text createText(Composite topControl) {
        return new Text(topControl, this.defaultTextStyle);
    }

    protected void handleFieldValueAndControlChanged() {
    }

    public Text getFieldControl() {
        return this.text;
    }

    @Override
    protected void doUpdateWidgetFromValue() {
        String fieldValue = (String)this.getFieldValue();
        if (!this.text.getText().equals(fieldValue)) {
            this.text.setText(fieldValue);
        }
    }

    @Override
    protected void doSetEnabled(boolean enabled) {
        SWTUtil.setEnabledIfOk((Control)this.label, enabled);
        SWTUtil.setEnabledIfOk((Control)this.text, enabled);
    }
}

