/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components.fields;

import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.LabelledFieldWidget;
import melnorme.utilbox.core.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RadioSelectionField<E extends Enum<?>>
extends LabelledFieldWidget<E> {
    protected final E[] values;
    protected final Button[] radioButtons;

    public RadioSelectionField(E[] values) {
        super(null, LabelledFieldWidget.Option_AllowNull.NO, values[0]);
        Assert.AssertNamespace.assertTrue((values != null && values.length > 0 ? 1 : 0) != 0);
        this.values = values;
        this.radioButtons = new Button[values.length];
    }

    public int getSelectionIndex() {
        return this.findIndexForValue((Enum)this.getFieldValue());
    }

    protected int findIndexForValue(E value) {
        int ix = 0;
        while (ix < this.values.length) {
            if (this.values[ix] == value) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    @Override
    public int getPreferredLayoutColumns() {
        return 1;
    }

    @Override
    protected void createContents_all(Composite topControl) {
        this.createContents_RadioButtons(topControl);
    }

    protected void createContents_RadioButtons(Composite topControl) {
        int i = 0;
        while (i < this.values.length) {
            int index = i;
            E value = this.values[i];
            String label = this.getLabelForValue(value);
            this.radioButtons[index] = SWTFactoryUtil.createButton(topControl, 16, label);
            this.radioButtons[index].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object newValue = RadioSelectionField.this.getValueFromControl();
                    if (newValue != RadioSelectionField.this.getFieldValue()) {
                        RadioSelectionField.this.setFieldValueFromControl(newValue);
                    }
                }
            });
            ++i;
        }
    }

    protected String getLabelForValue(E value) {
        return ((Enum)value).toString();
    }

    @Override
    protected void createContents_layout() {
        GridLayout gridLayout = (GridLayout)this.getFieldControl().getParent().getLayout();
        int numColumns = gridLayout.numColumns;
        Button[] buttonArray = this.radioButtons;
        int n = this.radioButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.setLayoutData((Object)RadioSelectionField.gdfFillDefaults().span(numColumns, 1).grab(true, false).create());
            ++n2;
        }
    }

    public Button getFieldControl() {
        return this.radioButtons[0];
    }

    public Button[] getRadioControls() {
        return this.radioButtons;
    }

    @Override
    protected void doUpdateWidgetFromValue() {
        int indexValue = this.getSelectionIndex();
        this.setControlButtonSelection(indexValue);
        Assert.AssertNamespace.assertTrue((this.getValueFromControl() == this.getFieldValue() ? 1 : 0) != 0);
    }

    protected void setControlButtonSelection(int indexValue) {
        int ix = 0;
        while (ix < this.radioButtons.length) {
            boolean newSelection;
            Button button = this.radioButtons[ix];
            boolean bl = newSelection = ix == indexValue;
            if (button.getSelection() != newSelection) {
                button.setSelection(newSelection);
            }
            ++ix;
        }
    }

    protected E getValueFromControl() {
        int ix = 0;
        while (ix < this.radioButtons.length) {
            if (this.radioButtons[ix].getSelection()) {
                return this.values[ix];
            }
            ++ix;
        }
        return null;
    }

    @Override
    protected void doSetEnabled(boolean enabled) {
        Button[] buttonArray = this.radioButtons;
        int n = this.radioButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            SWTUtil.setEnabledIfOk((Control)button, enabled);
            ++n2;
        }
    }
}

