/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components.fields;

import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.components.fields.ButtonTextField;
import melnorme.util.swt.components.fields.CheckBoxField;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.IProperty;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class EnablementButtonTextField
extends ButtonTextField {
    public static final String LABEL_UseDefault = "Use default:";
    protected final CheckBoxField useDefaultField;
    protected final boolean createUseDefaultComponent;
    protected final IProperty<String> effectiveValueProperty = new IProperty<String>(){

        public String get() {
            return EnablementButtonTextField.this.getEffectiveFieldValue();
        }

        public void set(String value) {
            EnablementButtonTextField.this.setEffectiveFieldValue(value);
        }
    };

    public EnablementButtonTextField(String labelText, String useDefaultCheckboxLabel, String buttonlabel) {
        super(labelText, buttonlabel);
        this.useDefaultField = this.createUseDefaultField(useDefaultCheckboxLabel);
        this.createUseDefaultComponent = useDefaultCheckboxLabel != null;
        this.useDefaultField.setFieldValue(this.createUseDefaultComponent);
        this.useDefaultField.addChangeListener(this::updateDefaultFieldValue);
    }

    protected CheckBoxField createUseDefaultField(String enablementCheckBoxLabel) {
        return new CheckBoxField(enablementCheckBoxLabel);
    }

    public CheckBoxField getUseDefaultField() {
        return this.useDefaultField;
    }

    public boolean isUseDefault() {
        return this.useDefaultField.getBooleanFieldValue();
    }

    public String getEffectiveFieldValue() {
        return this.isUseDefault() ? null : (String)super.getFieldValue();
    }

    public void setEffectiveFieldValue(String effectiveFieldValue) {
        this.getUseDefaultField().setFieldValue(effectiveFieldValue == null);
        if (effectiveFieldValue != null) {
            this.setFieldValue(effectiveFieldValue);
        }
    }

    public void updateDefaultFieldValue() {
        if (this.isUseDefault()) {
            try {
                this.setFieldValue(this.getDefaultFieldValue());
            }
            catch (CommonException e) {
                this.setFieldValue("");
            }
        }
    }

    public IProperty<String> asEffectiveValueProperty2() {
        return this.effectiveValueProperty;
    }

    protected abstract String getDefaultFieldValue() throws CommonException;

    @Override
    protected void doUpdateWidgetFromValue() {
        this.updateDefaultFieldValue();
        super.doUpdateWidgetFromValue();
    }

    @Override
    protected Composite doCreateTopLevelControl(Composite parent) {
        return SWTFactoryUtil.createGroup(parent, this.getLabelText(), 0);
    }

    @Override
    protected GridLayoutFactory createTopLevelLayout() {
        return GridLayoutFactory.swtDefaults().numColumns(this.getPreferredLayoutColumns());
    }

    @Override
    public int getPreferredLayoutColumns() {
        return 2;
    }

    @Override
    protected void createContents_all(Composite topControl) {
        this.createContents_EnablementCheckBox(topControl);
        super.createContents_all(topControl);
    }

    protected void createContents_EnablementCheckBox(Composite topControl) {
        if (this.createUseDefaultComponent) {
            Composite enablementTopControl = this.useDefaultField.createComponent(topControl);
            GridDataFactory.swtDefaults().span(this.getPreferredLayoutColumns(), 1).applyTo((Control)enablementTopControl);
            this.useDefaultField.addChangeListener(this::updateWidgetFromInput);
        }
    }

    @Override
    protected void createContents_Label(Composite parent) {
    }

    @Override
    protected void doSetEnabled(boolean enabled) {
        super.doSetEnabled(enabled && !this.isUseDefault());
        this.useDefaultField.setEnabled(enabled);
    }
}

