/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components.fields;

import melnorme.util.swt.SWTLayoutUtil;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.FieldWidget;
import melnorme.util.swt.components.LabelledFieldWidget;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.fields.IProperty;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboBoxField
extends LabelledFieldWidget<Integer> {
    protected final String[] valueLabels;
    protected final String[] values;
    protected Combo combo;
    protected final IProperty<String> stringProperty = new IProperty<String>(){

        public String get() {
            return ComboBoxField.this.getFieldStringValue();
        }

        public void set(String value) {
            ComboBoxField.this.setFieldStringValue(value);
        }
    };

    public ComboBoxField(String labelText, String[] labels, String[] values) {
        super(labelText, LabelledFieldWidget.Option_AllowNull.NO, 0);
        this.valueLabels = labels;
        this.values = values;
        Assert.AssertNamespace.assertTrue((labels != null && values != null && labels.length == values.length ? 1 : 0) != 0);
        Assert.AssertNamespace.assertTrue((labels.length > 0 ? 1 : 0) != 0);
    }

    @Override
    public int getPreferredLayoutColumns() {
        return 2;
    }

    @Override
    protected void createContents_all(Composite topControl) {
        this.createContents_Label(topControl);
        this.createContents_Combo(topControl);
    }

    @Override
    protected void createContents_layout() {
        SWTLayoutUtil.layout2Controls_spanLast((Control)this.label, (Control)this.combo);
    }

    protected void createContents_Combo(Composite topControl) {
        this.combo = ComboBoxField.createFieldCombo(this, topControl, 12);
        this.combo.setFont(topControl.getFont());
        this.combo.setItems(this.valueLabels);
    }

    public Combo getFieldControl() {
        return this.combo;
    }

    @Override
    protected void doUpdateWidgetFromValue() {
        int indexValue = (Integer)this.getFieldValue();
        if (indexValue == -1) {
            return;
        }
        String label = this.valueLabels[indexValue];
        this.combo.setText(label);
        Assert.AssertNamespace.assertTrue((this.combo.getSelectionIndex() == indexValue ? 1 : 0) != 0);
    }

    public String getFieldStringValue() {
        int indexValue = (Integer)this.getFieldValue();
        return this.getPrefValueFromIndex(indexValue);
    }

    protected String getPrefValueFromIndex(int index) {
        return index == -1 ? "" : this.values[index];
    }

    public void setFieldStringValue(String stringValue) {
        int indexValue = this.findIndexForStringValue(stringValue);
        this.setFieldValue(indexValue);
    }

    protected int findIndexForStringValue(String stringValue) {
        int index = 0;
        while (index < this.values.length) {
            if (this.values[index].equals(stringValue)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public IProperty<String> asStringProperty() {
        return this.stringProperty;
    }

    public static Combo createFieldCombo(final FieldWidget<Integer> field, Composite parent, int style) {
        final Combo combo = new Combo(parent, style);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = combo.getSelectionIndex();
                field.setFieldValueFromControl(selectionIndex);
            }
        });
        return combo;
    }

    @Override
    protected void doSetEnabled(boolean enabled) {
        SWTUtil.setEnabledIfOk((Control)this.combo, enabled);
    }
}

