/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components;

import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.AbstractDisableableWidget;
import melnorme.utilbox.fields.Field;
import melnorme.utilbox.fields.FieldValueListener;
import melnorme.utilbox.fields.IField;
import melnorme.utilbox.fields.IFieldView;
import melnorme.utilbox.fields.validation.IValidatableField;
import melnorme.utilbox.fields.validation.ValidationField;
import melnorme.utilbox.fields.validation.ValidationSource;
import melnorme.utilbox.fields.validation.Validator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class FieldWidget<VALUE>
extends AbstractDisableableWidget
implements IField<VALUE>,
IValidatableField<VALUE> {
    private final Field<VALUE> field;
    protected boolean listenersNeedNotify;
    protected boolean settingValueFromControl;

    public FieldWidget() {
        this(new Field(null));
    }

    public FieldWidget(VALUE defaultFieldValue) {
        this(new Field(defaultFieldValue));
    }

    public FieldWidget(Field<VALUE> domainField) {
        this.field = domainField;
        this.field.addChangeListener(new FieldValueListener.FieldChangeListener(){

            public void fieldValueChanged() {
                if (!FieldWidget.this.settingValueFromControl) {
                    FieldWidget.this.updateWidgetFromInput();
                }
            }
        });
    }

    public Field<VALUE> getField() {
        return this.field;
    }

    public VALUE getFieldValue() {
        return (VALUE)this.field.getFieldValue();
    }

    public void setFieldValue(VALUE value) {
        this.doSetFieldValue(value);
    }

    public void setFieldValueFromControl(VALUE newValue) {
        this.settingValueFromControl = true;
        try {
            this.doSetFieldValue(newValue);
        }
        finally {
            this.settingValueFromControl = false;
        }
    }

    protected void doSetFieldValue(VALUE newValue) {
        this.field.setFieldValue(newValue);
    }

    public void fireFieldValueChanged() {
        this.field.fireFieldValueChanged();
    }

    public void addListener(FieldValueListener<? super VALUE> listener) {
        this.field.addListener(listener);
    }

    public void removeListener(FieldValueListener<? super VALUE> listener) {
        this.field.removeListener(listener);
    }

    @Override
    public void doUpdateWidgetFromInput() {
        if (this.isCreated()) {
            this.doUpdateWidgetFromValue();
        }
    }

    protected abstract void doUpdateWidgetFromValue();

    @Override
    protected abstract void createContents(Composite var1);

    public abstract Control getFieldControl();

    public boolean isCreated() {
        return SWTUtil.isOkToUse(this.getFieldControl());
    }

    @Override
    public ValidationField getValidation() {
        return super.getValidation();
    }

    public void addFieldValidator(boolean init, Validator<VALUE, ?> validator) {
        this.getValidation().addFieldValidator(init, (IFieldView)this, validator);
    }

    public void addFieldValidation(boolean init, ValidationSource validationSource) {
        this.getValidation().addFieldValidation(init, (IFieldView)this, validationSource);
    }

    public void addFieldValidationX(boolean init, ValidationSource.ValidationSourceX validationSource) {
        this.getValidation().addFieldValidation(init, (IFieldView)this, (ValidationSource)validationSource);
    }
}

