/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt.components;

import melnorme.lang.ide.ui.preferences.common.AbstractWidgetExt;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.IDisableableWidget;
import melnorme.utilbox.core.Assert;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractDisableableWidget
extends AbstractWidgetExt
implements IDisableableWidget {
    protected AbstractDisableableWidget parentWidget;
    protected boolean enabled = true;
    public boolean onlyValidateWhenEnabled = true;

    public void setParent(AbstractDisableableWidget parent) {
        Assert.AssertNamespace.assertTrue((this.parentWidget == null ? 1 : 0) != 0);
        this.parentWidget = (AbstractDisableableWidget)Assert.AssertNamespace.assertNotNull((Object)parent);
    }

    public boolean isEnabled() {
        return this.enabled && (this.parentWidget == null || this.parentWidget.isEnabled());
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateControlEnablement2();
    }

    protected void updateControlEnablement2() {
        this.doSetEnabled(this.isEnabled());
        this.updateValidationStatusForEnablement();
    }

    protected abstract void doSetEnabled(boolean var1);

    protected void updateValidationStatusForEnablement() {
        if (this.onlyValidateWhenEnabled) {
            if (!this.isEnabled()) {
                this.validation.set(null);
            } else {
                this.validation.updateFieldValue();
            }
        }
    }

    @Override
    public void updateWidgetFromInput() {
        this.updateControlEnablement2();
        this.doUpdateWidgetFromInput();
    }

    protected void doUpdateWidgetFromInput() {
    }

    protected static void setControlEnabled(Control control, boolean enabled) {
        SWTUtil.setEnabledIfOk(control, enabled);
    }
}

