/*
 * Decompiled with CFR 0.152.
 */
package melnorme.util.swt;

import melnorme.utilbox.core.Assert;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusLevel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SWTUtil {
    public static boolean isOkToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public static void setEnabledIfOk(Control control, boolean enabled) {
        if (SWTUtil.isOkToUse(control)) {
            control.setEnabled(enabled);
        }
    }

    public static <T extends Resource> T dispose(T resource) {
        if (resource != null) {
            resource.dispose();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    public static void recursiveSetEnabled(Composite composite, boolean enabled) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                SWTUtil.recursiveSetEnabled((Composite)control, enabled);
            }
            control.setEnabled(enabled);
            ++n2;
        }
    }

    public static void runInSWTThread(Runnable runnable) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public static int showInfoMsgBox(Shell shell, String title, String message) {
        MessageBox messageBox = new MessageBox(shell, 32);
        messageBox.setText(title);
        messageBox.setMessage(message);
        return messageBox.open();
    }

    public static void post_setFocus(final Text control) {
        if (!SWTUtil.isOkToUse((Control)control)) {
            return;
        }
        Display display = control.getDisplay();
        if (display == Display.getCurrent()) {
            control.setFocus();
        } else {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        control.setFocus();
                    }
                }
            });
        }
    }

    public static int statusLevelToMessageDialogKing(StatusLevel statusLevel) {
        switch (statusLevel) {
            case ERROR: {
                return 1;
            }
            case WARNING: {
                return 4;
            }
            case INFO: {
                return 2;
            }
            case OK: {
                return 0;
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }

    public static Image getSWTImageForStatusLevel(StatusLevel statusLevel2) {
        return SWTUtil.getSystemImage(SWTUtil.getSystemImageCode(statusLevel2));
    }

    public static int getSystemImageCode(StatusLevel statusLevel) {
        switch (statusLevel) {
            case ERROR: {
                return 1;
            }
            case WARNING: {
                return 8;
            }
            case INFO: {
                return 2;
            }
            case OK: {
                return 16;
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }

    public static Image getImageForSeverity(Severity severity) {
        switch (severity) {
            case ERROR: {
                return SWTUtil.getSystemImage(1);
            }
            case WARNING: {
                return SWTUtil.getSystemImage(8);
            }
            case INFO: {
                return SWTUtil.getSystemImage(2);
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }

    public static Image getSystemImage(int imageID) {
        return Display.getCurrent().getSystemImage(imageID);
    }
}

