/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.views;

import melnorme.lang.ide.ui.LangImageProvider;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.LangUIPlugin_Actual;
import melnorme.lang.ide.ui.views.AbstractLangLabelProvider;
import melnorme.lang.tooling.ElementAttributes;
import melnorme.lang.tooling.structure.StructureElement;
import melnorme.lang.tooling.structure.StructureElementKind;
import melnorme.util.swt.jface.IManagedImage;
import melnorme.util.swt.jface.resources.LangElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public abstract class StructureElementLabelProvider
extends AbstractLangLabelProvider {
    public static DelegatingStyledCellLabelProvider createLangLabelProvider() {
        StructureElementLabelProvider labelProvider = LangUIPlugin_Actual.getStructureElementLabelProvider();
        return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider);
    }

    @Override
    public StyledString getStyledText(Object element) {
        if (element instanceof StructureElement) {
            StructureElement structureElement = (StructureElement)element;
            return this.getStyledText(structureElement);
        }
        return null;
    }

    protected StyledString getStyledText(StructureElement structureElement) {
        StyledString styledString = new StyledString(structureElement.getName());
        if (structureElement.getType() != null) {
            String typeSuffix = String.valueOf(this.getTypeDescriptionPrefix(structureElement)) + structureElement.getType();
            styledString.append(new StyledString(typeSuffix, StyledString.DECORATIONS_STYLER));
        }
        return styledString;
    }

    protected String getTypeDescriptionPrefix(StructureElement structureElement) {
        return " : ";
    }

    public Image getImage(Object element) {
        if (element instanceof StructureElement) {
            StructureElement structureElement = (StructureElement)element;
            return this.getImage(structureElement);
        }
        return null;
    }

    public Image getImage(StructureElement element) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(element);
        return LangImages.getImageDescriptorRegistry().get(imageDescriptor);
    }

    protected ImageDescriptor getImageDescriptor(StructureElement element) {
        ImageDescriptor baseImageDescriptor = this.getBaseImageDescriptor(element);
        return this.getElementImageDescriptor(baseImageDescriptor, element.getAttributes());
    }

    protected ImageDescriptor getBaseImageDescriptor(StructureElement structureElement) {
        return ((IManagedImage)structureElement.getKind().switchOnKind((StructureElementKind.StructureElementKindVisitor)new LangImageProvider())).getDescriptor();
    }

    public LangElementImageDescriptor getElementImageDescriptor(ImageDescriptor baseImage, ElementAttributes elementAttributes) {
        return new LangElementImageDescriptor(baseImage, elementAttributes);
    }
}

