/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.common.ops.Operation;
import melnorme.lang.tooling.common.ops.ResultOperation;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class WorkbenchOperationExecutor {
    protected final boolean allowBackgroundAlready;
    protected final boolean executeInUIOnly;

    public WorkbenchOperationExecutor() {
        this(false);
    }

    public WorkbenchOperationExecutor(boolean executeInUIOnly) {
        this.executeInUIOnly = executeInUIOnly;
        this.allowBackgroundAlready = !executeInUIOnly;
    }

    protected final void runRunnableWithProgress(IRunnableWithProgress progressRunnable) throws InvocationTargetException, InterruptedException {
        if (this.allowBackgroundAlready && Display.getCurrent() == null) {
            Assert.AssertNamespace.assertTrue((!this.executeInUIOnly ? 1 : 0) != 0);
            progressRunnable.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            Assert.AssertNamespace.assertTrue((Display.getCurrent() != null ? 1 : 0) != 0);
            this.doRunRunnableWithProgress(progressRunnable);
        }
    }

    protected void doRunRunnableWithProgress(IRunnableWithProgress progressRunnable) throws InvocationTargetException, InterruptedException {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        progressService.run(!this.executeInUIOnly, true, progressRunnable);
    }

    public void execute(final Operation coreOperation) throws CommonException, OperationCancellation {
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        coreOperation.execute(EclipseUtils.om((IProgressMonitor)monitor));
                    }
                    catch (OperationCancellation | CommonException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runRunnableWithProgress(runnableWithProgress);
        }
        catch (InvocationTargetException ite) {
            try {
                throw ite.getCause();
            }
            catch (OperationCancellation | CommonException original) {
                throw original;
            }
            catch (Throwable e) {
                throw new CommonException("Internal Error", e);
            }
        }
        catch (InterruptedException e) {
            throw new CommonException("Internal Error", (Throwable)e);
        }
    }

    public <R> R callInBackground(final Function<IOperationMonitor, R> op) {
        final AtomicReference resultHolder = new AtomicReference();
        Operation opWrapper = new Operation(){

            public void execute(IOperationMonitor om) {
                Object result = op.apply(om);
                resultHolder.set(result);
            }
        };
        try {
            this.execute(opWrapper);
        }
        catch (OperationCancellation | CommonException e) {
            throw Assert.AssertNamespace.assertFail();
        }
        return (R)resultHolder.get();
    }

    public <R> R invokeInBackground(final ResultOperation<R> op) throws CommonException, OperationCancellation {
        final AtomicReference resultHolder = new AtomicReference();
        this.execute(new Operation(){

            public void execute(IOperationMonitor om) throws CommonException, OperationCancellation {
                Object result = op.executeOp(om);
                resultHolder.set(result);
            }
        });
        return (R)resultHolder.get();
    }

    public static class ProgressMonitorDialogOpRunner
    extends WorkbenchOperationExecutor {
        protected final ProgressMonitorDialog progressMonitorDialog;

        public ProgressMonitorDialogOpRunner(Shell shell) {
            this.progressMonitorDialog = (ProgressMonitorDialog)Assert.AssertNamespace.assertNotNull((Object)new ProgressMonitorDialog(shell));
        }

        @Override
        protected void doRunRunnableWithProgress(IRunnableWithProgress progressRunnable) throws InvocationTargetException, InterruptedException {
            this.progressMonitorDialog.run(!this.executeInUIOnly, true, progressRunnable);
        }
    }
}

