/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils.operations;

import java.text.MessageFormat;
import melnorme.lang.ide.ui.LangUIMessages;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import org.eclipse.swt.widgets.Display;

public abstract class BasicUIOperation
implements Runnable {
    protected static final String MSG_ERROR_EXECUTING_OPERATION = "Error executing: {0}.";
    protected static final String MSG_INTERNAL_ERROR_EXECUTING_OPERATION = "Internal error executing: {0}.";
    protected final String operationName;

    public BasicUIOperation() {
        this.operationName = (String)Assert.AssertNamespace.assertNotNull((Object)"");
    }

    public BasicUIOperation(String operationName) {
        this.operationName = (String)Assert.AssertNamespace.assertNotNull((Object)operationName);
    }

    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public final void run() {
        this.executeAndHandle();
    }

    public boolean executeAndHandle() {
        Assert.AssertNamespace.assertTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        try {
            this.execute();
            return true;
        }
        catch (CommonException ce) {
            this.handleError(ce);
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
        }
        catch (OperationCancellation operationCancellation) {
            // empty catch block
        }
        return false;
    }

    protected void handleError(CommonException ce) {
        String title = this.operationName.isEmpty() ? LangUIMessages.Error : MessageFormat.format(MSG_ERROR_EXECUTING_OPERATION, this.operationName);
        UIOperationsStatusHandler.handleStatus(title, ce);
    }

    protected void handleRuntimeException(RuntimeException re) {
        String title = this.operationName.isEmpty() ? LangUIMessages.InternalError : MessageFormat.format(MSG_INTERNAL_ERROR_EXECUTING_OPERATION, this.operationName);
        UIOperationsStatusHandler.handleStatus(true, null, title, LangUIMessages.InternalErrorOccured, re);
    }

    public abstract void execute() throws CommonException, OperationCancellation;
}

