/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils;

import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.ResourceUtil;

public class WorkbenchUtils {
    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = WorkbenchUtils.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = WorkbenchUtils.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static IWorkbenchSite getActiveSite() {
        IWorkbenchPage workbenchPage = WorkbenchUtils.getActivePage();
        IWorkbenchPart part = workbenchPage == null ? null : workbenchPage.getActivePart();
        return part == null ? null : part.getSite();
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = WorkbenchUtils.getActivePage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static IResource getContextResource() {
        Object obj;
        IStructuredSelection ss;
        IWorkbenchPage page = WorkbenchUtils.getActivePage();
        if (page == null) {
            return null;
        }
        ISelection selection = page.getSelection();
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof IResource) {
            return (IResource)obj;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        return ResourceUtil.getResource((IEditorInput)editorInput);
    }

    public static IWorkbenchPart getActivePart(IWorkbenchPartSite site) {
        IWorkbenchWindow window = site.getWorkbenchWindow();
        IPartService service = window.getPartService();
        return service.getActivePart();
    }

    public static void openPreferencePage(Shell shell, String prefPageId) {
        PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)prefPageId, null, null);
        if (prefDialog != null) {
            prefDialog.open();
        } else {
            String message = "Preference page not found: `" + prefPageId + "`.";
            UIOperationsStatusHandler.handleInternalError(shell, message, null);
        }
    }
}

