/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils;

import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.AbstractWidget;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.status.StatusException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class StatusMessageDialog2
extends Dialog {
    protected final String title;
    protected final IconAndMessageWidget iconAndMessageWidget;

    public StatusMessageDialog2(Shell shell, String title, StatusException statusMessage) {
        super(shell);
        Assert.AssertNamespace.assertNotNull((Object)((Object)statusMessage));
        this.title = title;
        this.iconAndMessageWidget = this.createIconAndMessageWidget();
        this.iconAndMessageWidget.setStatusMessage(statusMessage);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite topControl = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)topControl.getLayout();
        gridLayout.numColumns = 2;
        this.iconAndMessageWidget.createComponentInlined(topControl);
        this.iconAndMessageWidget.messageControlLayoutData().widthHint = this.convertHorizontalDLUsToPixels(300);
        return topControl;
    }

    protected IconAndMessageWidget createIconAndMessageWidget() {
        return new IconAndMessageWidget();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public static class IconAndMessageWidget
    extends AbstractWidget {
        protected StatusException statusMessage;
        protected Label imageControl;
        protected Label messageControl;

        @Override
        public int getPreferredLayoutColumns() {
            return 2;
        }

        public void setStatusMessage(StatusException statusMessage) {
            this.statusMessage = (StatusException)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)statusMessage)));
        }

        @Override
        protected void createContents(Composite topControl) {
            this.imageControl = this.createImageControl(topControl);
            this.createMessageControl(topControl);
        }

        protected Label createImageControl(Composite topControl) {
            return SWTFactoryUtil.createIconLabel(topControl, this.getImage(), GridDataFactory.fillDefaults().align(0x1000000, 1).create());
        }

        protected Image getImage() {
            return SWTUtil.getImageForSeverity(this.statusMessage.getSeverity());
        }

        protected void createMessageControl(Composite topControl) {
            String message = this.statusMessage.getMultiLineRender();
            this.messageControl = SWTFactoryUtil.createLabel(topControl, 64, message, IconAndMessageWidget.gdGrabAll());
        }

        public GridData messageControlLayoutData() {
            Assert.AssertNamespace.assertNotNull((Object)this.messageControl);
            return (GridData)this.messageControl.getLayoutData();
        }

        @Override
        protected void updateWidgetFromInput() {
        }
    }
}

