/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils;

import melnorme.util.swt.SWTFactory;
import melnorme.util.swt.SWTUtil;
import melnorme.utilbox.status.StatusLevel;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class StatusMessageDialog
extends IconAndMessageDialog {
    protected final String ignoreButtonLabel;
    protected final String title;
    protected final StatusLevel statusLevel;
    protected Button ignore;

    public StatusMessageDialog(Shell parentShell, String title, StatusLevel statusLevel, String message) {
        this(parentShell, title, statusLevel, message, "Ignore similar errors for this operation, during this session.");
    }

    public StatusMessageDialog(Shell parentShell, String title, StatusLevel statusLevel, String message, String ignoreButtonLabel) {
        super(parentShell);
        this.title = title;
        this.statusLevel = statusLevel;
        this.message = message;
        this.ignoreButtonLabel = ignoreButtonLabel;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Image getImage() {
        return SWTUtil.getSWTImageForStatusLevel(this.statusLevel);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4) * 2;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.ignore = SWTFactory.createButton(parent, 32, this.ignoreButtonLabel, GridDataFactory.swtDefaults().span(2, 1).create());
        this.ignore.setSelection(true);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public void okPressed() {
        if (this.ignore.getSelection()) {
            this.setIgnoreFutureMessages();
        }
        super.okPressed();
    }

    protected abstract void setIgnoreFutureMessages();
}

