/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils;

import java.net.URL;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.jface.IManagedImage;
import melnorme.utilbox.core.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class PluginImagesHelper {
    protected final Bundle bundle;
    protected final IPath imagesPath;
    protected final boolean failOnMissingImage;
    protected final ImageRegistry imageRegistry;

    public PluginImagesHelper(Bundle bundle, IPath imagesPath, boolean failOnMissingImage) {
        this.bundle = (Bundle)Assert.AssertNamespace.assertNotNull((Object)bundle);
        this.imagesPath = imagesPath;
        this.failOnMissingImage = failOnMissingImage;
        this.imageRegistry = new ImageRegistry(SWTUtil.getStandardDisplay());
    }

    public ImageRegistry getImageRegistry() {
        return this.imageRegistry;
    }

    protected static ImageDescriptor getImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public ImageDescriptor createImageDescriptor(String imagePath) {
        return this.createImageDescriptor(imagePath, false);
    }

    public ImageDescriptor createImageDescriptor(String imagePath, boolean useMissingImageDescriptor) {
        IPath path = this.imagesPath.append(imagePath);
        ImageDescriptor imageDescriptor = PluginImagesHelper.getImageDescriptor(this.bundle, path, useMissingImageDescriptor);
        if (this.failOnMissingImage) {
            Assert.AssertNamespace.assertNotNull((Object)imageDescriptor);
        }
        return imageDescriptor;
    }

    public ImageHandle createManaged(String imagePath) {
        ImageDescriptor result = this.createImageDescriptor(imagePath, false);
        Assert.AssertNamespace.assertNotNull((Object)result);
        return this.putManaged(imagePath, result);
    }

    public ImageHandle putManaged(String imageKey, ImageDescriptor imageDescriptor) {
        this.imageRegistry.put(imageKey, imageDescriptor);
        return new ImageHandle(imageKey);
    }

    public Image getImage(String key) {
        return this.imageRegistry.get(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.imageRegistry.getDescriptor(key);
    }

    public class ImageHandle
    implements IManagedImage {
        protected String imageKey;

        public ImageHandle(String imageKey) {
            this.imageKey = imageKey;
        }

        public String getKey() {
            return this.imageKey;
        }

        @Override
        public ImageRegistry getImageRegistry() {
            return PluginImagesHelper.this.imageRegistry;
        }

        @Override
        public Image getImage() {
            return PluginImagesHelper.this.imageRegistry.get(this.imageKey);
        }

        @Override
        public ImageDescriptor getDescriptor() {
            return PluginImagesHelper.this.imageRegistry.getDescriptor(this.imageKey);
        }
    }
}

