/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.utils;

import melnorme.util.swt.SWTUtil;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.status.IStatusMessage;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusLevel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;

public class DialogPageUtils {
    public static int severityToMessageType(Severity severity) {
        return DialogPageUtils.statusLevelToMessageType(severity.toStatusLevel());
    }

    public static int statusLevelToMessageType(StatusLevel statusLevel) {
        switch (statusLevel) {
            case OK: {
                return 0;
            }
            case INFO: {
                return 1;
            }
            case WARNING: {
                return 2;
            }
            case ERROR: {
                return 3;
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }

    public static int severityToMessageType(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        return 0;
    }

    public static void setPrefPageStatus(PreferencePage prefPage, IStatusMessage status) {
        if (!SWTUtil.isOkToUse(prefPage.getControl())) {
            return;
        }
        prefPage.setValid(status == null || !status.getSeverity().isError());
        DialogPageUtils.setDialogPageStatus(prefPage, status);
    }

    public static void setDialogPageStatus(PreferencePage prefPage, IStatusMessage status) {
        if (!SWTUtil.isOkToUse(prefPage.getControl())) {
            return;
        }
        if (status == null) {
            prefPage.setMessage(null);
        } else {
            prefPage.setMessage(status.getMessage(), DialogPageUtils.severityToMessageType(status.getSeverity()));
        }
    }

    public static void applyStatusToPage(PreferencePage preferencePage, IStatus status) {
        preferencePage.setValid(status.isOK());
        DialogPageUtils.applyStatusToPage(preferencePage, status);
    }

    public static void applyStatusToPage(DialogPage page, IStatus status) {
        String message = StringUtil.emptyAsNull((String)status.getMessage());
        if (status.getSeverity() == 4) {
            page.setErrorMessage(message);
            page.setMessage(null);
        } else {
            page.setErrorMessage(null);
            page.setMessage(message, DialogPageUtils.severityToMessageType(status));
        }
    }
}

