/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.completion;

import java.text.MessageFormat;
import melnorme.lang.ide.core.text.ISourceBufferExt;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.editor.hover.BrowserControlCreator;
import melnorme.lang.ide.ui.templates.LangTemplateCompletionProposalComputer;
import melnorme.lang.ide.ui.text.completion.CompletionProposalsGrouping;
import melnorme.lang.ide.ui.text.completion.ContenAssistProcessorExt;
import melnorme.lang.ide.ui.text.completion.ContentAssistantExt;
import melnorme.lang.ide.ui.text.completion.ILangCompletionProposalComputer;
import melnorme.lang.ide.ui.utils.UIOperationsStatusHandler;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.lang.tooling.utils.HTMLHelper;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.ITextEditor;

public class LangContentAssistProcessor
extends ContenAssistProcessorExt {
    protected final ContentAssistantExt contentAssistant;
    protected final Indexable<CompletionProposalsGrouping> categories;
    protected final ISourceBufferExt sourceBuffer;
    protected final ITextEditor editor;
    protected final IProject project;
    protected int invocationIteration = 0;
    protected boolean isAutoActivation = false;

    public LangContentAssistProcessor(ContentAssistantExt contentAssistant, Indexable<CompletionProposalsGrouping> groupings, ISourceBufferExt sourceBuffer, ITextEditor editor) {
        this.contentAssistant = (ContentAssistantExt)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)contentAssistant)));
        this.categories = groupings;
        Assert.AssertNamespace.assertTrue((this.categories != null && this.categories.size() > 0 ? 1 : 0) != 0);
        this.sourceBuffer = (ISourceBufferExt)Assert.AssertNamespace.assertNotNull((Object)sourceBuffer);
        this.editor = editor;
        this.project = editor == null ? null : EditorUtils.getAssociatedProject(editor.getEditorInput());
        contentAssistant.addCompletionListener(new CompletionSessionListener());
    }

    protected CompletionProposalsGrouping getCurrentCategory() {
        return this.getCategory(this.invocationIteration);
    }

    protected CompletionProposalsGrouping getCategory(int categoryIndex) {
        Assert.AssertNamespace.assertTrue((categoryIndex >= 0 ? 1 : 0) != 0);
        int cappedIndex = categoryIndex % this.categories.size();
        return (CompletionProposalsGrouping)this.categories.get(cappedIndex);
    }

    protected void listener_assistSessionStarted() {
        for (CompletionProposalsGrouping cat : this.categories) {
            cat.sessionStarted();
        }
    }

    protected void listener_assistSessionEnded() {
        for (CompletionProposalsGrouping cat : this.categories) {
            cat.sessionEnded();
        }
    }

    @Override
    protected void resetComputeState() {
        super.resetComputeState();
        this.contentAssistant.setStatusMessage(this.createIterationMessage());
        this.contentAssistant.setEmptyMessage(this.createEmptyMessage());
    }

    @Override
    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset) {
        CompletionProposalsGrouping cat = this.getCurrentCategory();
        ++this.invocationIteration;
        try {
            Indexable<ICompletionProposal> proposals = cat.computeCompletionProposals(this.sourceBuffer, viewer, offset);
            return (ICompletionProposal[])proposals.toArray(ICompletionProposal.class);
        }
        catch (OperationCancellation e) {
            return null;
        }
        catch (CommonException ce) {
            return this.returnErrorResult(ce.getMultiLineRender());
        }
        catch (OperationSoftFailure e) {
            String errorMessage = e.getMessage();
            if (this.isAutoActivation) {
                this.setAndDisplayStatusLineErrorMessage("Error: " + errorMessage);
                return null;
            }
            return this.returnErrorResult(errorMessage);
        }
    }

    @Override
    protected IContextInformation[] doComputeContextInformation(ITextViewer viewer, int offset) {
        CompletionProposalsGrouping cat = this.getCurrentCategory();
        ++this.invocationIteration;
        Indexable<IContextInformation> proposals = cat.computeContextInformation(this.sourceBuffer, viewer, offset);
        this.setAndDisplayStatusLineErrorMessage(cat.getErrorMessage());
        return (IContextInformation[])proposals.toArray(IContextInformation.class);
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected ICompletionProposal[] returnErrorResult(String errorMessage) {
        Display.getCurrent().beep();
        return (ICompletionProposal[])CoreUtil.array((Object[])new ErrorCompletionProposal[]{new ErrorCompletionProposal(errorMessage)});
    }

    protected void showErrorDialog(CommonException ce) {
        UIOperationsStatusHandler.handleOperationStatus("Content Assist", ce);
    }

    protected void setAndDisplayStatusLineErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        EditorUtils.setStatusLineErrorMessage(this.editor, errorMessage, null);
        Display.getCurrent().beep();
    }

    protected String createEmptyMessage() {
        if (this.invocationIteration == 0) {
            return MessageFormat.format("No proposals", this.getCurrentCategory().getName());
        }
        return MessageFormat.format("No {0}", this.getCurrentCategory().getName());
    }

    protected String createIterationMessage() {
        KeySequence binding = this.getGroupingIterationBinding();
        String nextCategoryLabel = this.getCategory(this.invocationIteration + 1).getName();
        if (binding == null) {
            return MessageFormat.format("Click to show {1}", this.getCurrentCategory().getName(), nextCategoryLabel, null);
        }
        return MessageFormat.format("Press ''{2}'' to show {1}", this.getCurrentCategory().getName(), nextCategoryLabel, binding.format());
    }

    protected KeySequence getGroupingIterationBinding() {
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence binding = bindingSvc.getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (binding instanceof KeySequence) {
            return (KeySequence)binding;
        }
        return null;
    }

    protected class CompletionSessionListener
    implements ICompletionListener,
    ICompletionListenerExtension {
        public void assistSessionStarted(ContentAssistEvent event) {
            if (event.processor != LangContentAssistProcessor.this) {
                return;
            }
            LangContentAssistProcessor.this.invocationIteration = 0;
            LangContentAssistProcessor.this.isAutoActivation = event.isAutoActivated;
            if (event.assistant instanceof IContentAssistantExtension2) {
                IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                KeySequence binding = LangContentAssistProcessor.this.getGroupingIterationBinding();
                boolean repeatedModeEnabled = LangContentAssistProcessor.this.categories.size() > 1;
                this.setRepeatedModeStatus(extension, repeatedModeEnabled, binding);
            }
            LangContentAssistProcessor.this.listener_assistSessionStarted();
        }

        protected void setRepeatedModeStatus(IContentAssistantExtension2 caExt2, boolean enabled, KeySequence binding) {
            caExt2.setShowEmptyList(enabled);
            caExt2.setRepeatedInvocationMode(enabled);
            caExt2.setStatusLineVisible(enabled);
            if (enabled) {
                caExt2.setStatusMessage(LangContentAssistProcessor.this.createIterationMessage());
            }
            if (caExt2 instanceof IContentAssistantExtension3) {
                IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)caExt2;
                ext3.setRepeatedInvocationTrigger(binding);
            }
        }

        public void assistSessionRestarted(ContentAssistEvent event) {
            LangContentAssistProcessor.this.invocationIteration = 0;
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            if (event.processor != LangContentAssistProcessor.this) {
                return;
            }
            LangContentAssistProcessor.this.invocationIteration = 0;
            LangContentAssistProcessor.this.listener_assistSessionEnded();
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    }

    public static abstract class ContentAssistCategoriesBuilder {
        public ArrayList2<CompletionProposalsGrouping> getCategories() {
            ArrayList2 categories = new ArrayList2();
            categories.addIfNotNull((Object)this.createDefaultCategory());
            categories.addIfNotNull((Object)this.createSnippetsCategory());
            return categories;
        }

        protected CompletionProposalsGrouping createDefaultCategory() {
            ArrayList2<ILangCompletionProposalComputer> computers = this.createDefaultCategoryComputers();
            return new CompletionProposalsGrouping("default", "Default Proposals", null, computers);
        }

        protected ArrayList2<ILangCompletionProposalComputer> createDefaultCategoryComputers() {
            ArrayList2 computers = new ArrayList2();
            computers.addIfNotNull((Object)this.createDefaultSymbolsProposalComputer());
            computers.addIfNotNull((Object)this.createSnippetsProposalComputer());
            return computers;
        }

        protected abstract ILangCompletionProposalComputer createDefaultSymbolsProposalComputer();

        protected CompletionProposalsGrouping createSnippetsCategory() {
            ArrayList2 computers = new ArrayList2();
            computers.addIfNotNull((Object)this.createSnippetsProposalComputer());
            if (computers.isEmpty()) {
                return null;
            }
            return new CompletionProposalsGrouping("snippets", "Snippet Proposals", null, (ArrayList2<ILangCompletionProposalComputer>)computers);
        }

        protected ILangCompletionProposalComputer createSnippetsProposalComputer() {
            return new LangTemplateCompletionProposalComputer();
        }
    }

    public class ErrorCompletionProposal
    implements ICompletionProposal,
    ICompletionProposalExtension3,
    ICompletionProposalExtension4 {
        protected final String errorMessage;

        public ErrorCompletionProposal(String errorMessage) {
            this.errorMessage = (String)Assert.AssertNamespace.assertNotNull((Object)errorMessage);
        }

        public Image getImage() {
            return LangImages.NAV_Error.createImage();
        }

        public String getDisplayString() {
            return "An error occured during Content Assist.";
        }

        public String getAdditionalProposalInfo() {
            return BrowserControlCreator.wrapHTMLBody("<b>Error:</b><hr/> " + HTMLHelper.escapeToToHTML((String)this.errorMessage));
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public boolean isAutoInsertable() {
            return true;
        }

        public void apply(IDocument document) {
            LangContentAssistProcessor.this.showErrorDialog(new CommonException(this.errorMessage));
        }

        public IInformationControlCreator getInformationControlCreator() {
            return new BrowserControlCreator();
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return null;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return completionOffset;
        }
    }
}

