/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.completion;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.text.ISourceBufferExt;
import melnorme.lang.ide.ui.LangImageProvider;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.LangUIPlugin_Actual;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.text.completion.AbstractCompletionProposalComputer;
import melnorme.lang.ide.ui.text.completion.LangCompletionProposal;
import melnorme.lang.ide.ui.views.AbstractLangImageProvider;
import melnorme.lang.ide.ui.views.StructureElementLabelProvider;
import melnorme.lang.tooling.ToolCompletionProposal;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.lang.tooling.toolchain.ops.SourceOpContext;
import melnorme.lang.utils.concurrency.TimeoutCancelMonitor;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public abstract class LangCompletionProposalComputer
extends AbstractCompletionProposalComputer {
    protected boolean needsEditorSave() {
        return false;
    }

    @Override
    public Indexable<ICompletionProposal> computeCompletionProposals(ISourceBufferExt sourceBuffer, ITextViewer viewer, int offset) throws CommonException, OperationCancellation, OperationSoftFailure {
        if (this.needsEditorSave()) {
            sourceBuffer.trySaveBufferIfDirty();
        }
        SourceOpContext sourceOpContext = sourceBuffer.getSourceOpContext(offset, EditorUtils.getSelectedRange(viewer));
        TimeoutCancelMonitor cm = new TimeoutCancelMonitor(5000);
        try {
            return this.computeProposals(sourceOpContext, (ICancelMonitor)cm);
        }
        catch (OperationCancellation e) {
            if (cm.isCanceled()) {
                throw new OperationSoftFailure("Timeout invoking content assist.");
            }
            throw new OperationSoftFailure("Cancelled.");
        }
    }

    protected Indexable<ICompletionProposal> computeProposals(SourceOpContext sourceContext, ICancelMonitor cm) throws CommonException, OperationCancellation, OperationSoftFailure {
        Indexable<ToolCompletionProposal> resultProposals = this.doComputeProposals(sourceContext, cm);
        ArrayList2 proposals = new ArrayList2();
        for (ToolCompletionProposal proposal : resultProposals) {
            proposals.add((Object)this.adaptToolProposal(sourceContext, proposal));
        }
        return proposals;
    }

    protected abstract Indexable<ToolCompletionProposal> doComputeProposals(SourceOpContext var1, ICancelMonitor var2) throws CommonException, OperationCancellation, OperationSoftFailure;

    protected ICompletionProposal adaptToolProposal(SourceOpContext sourceContext, ToolCompletionProposal proposal) {
        IContextInformation ctxInfo = null;
        return new LangCompletionProposal(sourceContext, proposal, this.getImage(proposal), ctxInfo);
    }

    protected Image getImage(ToolCompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.createImageDescriptor(proposal);
        return LangImages.getImageDescriptorRegistry().get(imageDescriptor);
    }

    public ImageDescriptor createImageDescriptor(ToolCompletionProposal proposal) {
        ImageDescriptor baseImage = this.getBaseImageDescriptor(proposal);
        StructureElementLabelProvider labelDecorator = LangUIPlugin_Actual.getStructureElementLabelProvider();
        return labelDecorator.getElementImageDescriptor(baseImage, proposal.getAttributes());
    }

    protected ImageDescriptor getBaseImageDescriptor(ToolCompletionProposal proposal) {
        return this.getImageProvider().getImageDescriptor(proposal.getKind()).getDescriptor();
    }

    protected AbstractLangImageProvider getImageProvider() {
        return new LangImageProvider();
    }

    protected ToolManager.ToolManagerEngineToolRunner getEngineToolRunner() {
        return new ToolManager.ToolManagerEngineToolRunner(LangCore.getToolManager());
    }
}

