/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.completion;

import melnorme.lang.ide.ui.editor.LangSourceViewer;
import melnorme.lang.ide.ui.templates.LangTemplateProposal;
import melnorme.lang.ide.ui.text.completion.ContentAssistPreferenceHandler;
import melnorme.lang.ide.ui.text.completion.LangCompletionProposal;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.StringUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;

public class ContentAssistantExt
extends ContentAssistant {
    protected final LangSourceViewer langSourceViewer;
    protected final IPreferenceStore prefStore;
    protected String statusMessage;
    protected String additionalStatusMessage;

    public ContentAssistantExt(IPreferenceStore prefStore, LangSourceViewer langSourceViewer) {
        this.langSourceViewer = (LangSourceViewer)Assert.AssertNamespace.assertNotNull((Object)langSourceViewer);
        this.prefStore = (IPreferenceStore)Assert.AssertNamespace.assertNotNull((Object)prefStore);
        this.setSorter(new ContentAssistSorter());
    }

    public LangSourceViewer getSourceViewer() {
        return this.langSourceViewer;
    }

    public void configure() {
        new ContentAssistPreferenceHandler(this, this.prefStore, this.langSourceViewer).configureViewer();
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
        super.setStatusMessage(message);
    }

    public String getStatusMessage_() {
        return this.statusMessage;
    }

    public void setAdditionalStatusMessage(String additionalMessage) {
        this.additionalStatusMessage = additionalMessage;
        super.setStatusMessage(String.valueOf(StringUtil.nullAsEmpty((String)additionalMessage)) + StringUtil.prefixStr((String)" ", (String)this.statusMessage));
    }

    public String getAdditionalStatusMessage() {
        return this.additionalStatusMessage;
    }

    public static class ContentAssistSorter
    implements ICompletionProposalSorter {
        public int compare(ICompletionProposal proposalA, ICompletionProposal proposalB) {
            int relevanceB;
            int relevanceA = this.getRelevance(proposalA);
            if (relevanceA != (relevanceB = this.getRelevance(proposalB))) {
                return Integer.compare(relevanceA, relevanceB);
            }
            String p1SortString = this.getSortString(proposalA);
            String p2SortString = this.getSortString(proposalB);
            return p1SortString.compareTo(p2SortString);
        }

        protected int getRelevance(ICompletionProposal proposal) {
            if (proposal instanceof LangCompletionProposal) {
                LangCompletionProposal langProposal = (LangCompletionProposal)proposal;
                return langProposal.getRelevance();
            }
            return proposal instanceof LangTemplateProposal ? 100 : 0;
        }

        protected String getSortString(ICompletionProposal proposal) {
            String sortString;
            if (proposal instanceof LangCompletionProposal) {
                LangCompletionProposal langProposal = (LangCompletionProposal)proposal;
                sortString = langProposal.getSortString();
            } else {
                sortString = proposal.getDisplayString();
            }
            return sortString == null ? "\uffff" : sortString;
        }
    }
}

