/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.completion;

import melnorme.lang.ide.core.utils.prefs.IGlobalPreference;
import melnorme.lang.ide.ui.ContentAssistConstants;
import melnorme.lang.ide.ui.ContentAssistPreferences;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.editor.ProjectionViewerExt;
import melnorme.lang.ide.ui.editor.SourceViewerConfigurer;
import melnorme.lang.ide.ui.text.coloring.TextStyling;
import melnorme.lang.ide.ui.text.completion.ContentAssistantExt;
import melnorme.lang.ide.ui.text.completion.LangContentAssistProcessor;
import melnorme.util.swt.jface.text.ColorManager2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.fields.FieldValueListener;
import melnorme.utilbox.fields.IFieldView;
import melnorme.utilbox.ownership.IOwner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;

public class ContentAssistPreferenceHandler
extends SourceViewerConfigurer
implements ContentAssistConstants,
ContentAssistPreferences {
    protected final ContentAssistantExt assistant;

    public ContentAssistPreferenceHandler(ContentAssistantExt contentAssistantExt, IPreferenceStore prefStore, ProjectionViewerExt sourceViewer) {
        super(prefStore, sourceViewer);
        this.assistant = (ContentAssistantExt)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)contentAssistantExt)));
    }

    protected ColorManager2 getColorManager() {
        return LangUIPlugin.getInstance().getColorManager();
    }

    protected Color getColor(TextStyling textStyling) {
        return this.getColorManager().getColor(textStyling.rgb);
    }

    @Override
    protected void doConfigureViewer() {
        this.assistant.enableAutoActivation(true);
        this.listenToField((IGlobalPreference)AUTO_INSERT__SingleProposals, (FieldValueListener)newValue -> this.assistant.enableAutoInsert((boolean)newValue));
        this.listenToField((IGlobalPreference)AUTO_INSERT__CommonPrefixes, (FieldValueListener)newValue -> this.assistant.enablePrefixCompletion((boolean)newValue));
        this.listenToField((IGlobalPreference)AUTO_ACTIVATE__DotTrigger, (FieldValueListener)__ -> this.setAutoActivationTriggers(this.assistant, this.store));
        this.listenToField((IGlobalPreference)AUTO_ACTIVATE__DoubleColonTrigger, (FieldValueListener)__ -> this.setAutoActivationTriggers(this.assistant, this.store));
        this.listenToField((IGlobalPreference)AUTO_ACTIVATE__AlphaNumericTrigger, (FieldValueListener)__ -> this.setAutoActivationTriggers(this.assistant, this.store));
        this.listenToField((IGlobalPreference)AUTO_ACTIVATE__Delay, (FieldValueListener)newValue -> this.assistant.setAutoActivationDelay((int)newValue));
        this.listenToField(PROPOSALS_FOREGROUND_2, newValue -> this.assistant.setProposalSelectorForeground(this.getColor((TextStyling)newValue)));
        this.listenToField(PROPOSALS_BACKGROUND_2, newValue -> this.assistant.setProposalSelectorBackground(this.getColor((TextStyling)newValue)));
        this.listenToField(PARAMETERS_BACKGROUND_2, newValue -> {
            Color paramsFg = this.getColor((TextStyling)newValue);
            this.assistant.setContextInformationPopupForeground(paramsFg);
            this.assistant.setContextSelectorForeground(paramsFg);
        });
        this.listenToField(PROPOSALS_FOREGROUND_2, newValue -> {
            Color paramsBg = this.getColor((TextStyling)newValue);
            this.assistant.setContextInformationPopupBackground(paramsBg);
            this.assistant.setContextSelectorBackground(paramsBg);
        });
    }

    public <T> void listenToField(IGlobalPreference<T> preference, FieldValueListener<T> listener) {
        this.listenToField(preference.asField(), listener);
    }

    public <T> void listenToField(IFieldView<T> field, FieldValueListener<T> listener) {
        IOwner configurationOwned = this.sourceViewer.getConfigurationOwned();
        field.bindOwnedListener(configurationOwned, true, listener);
    }

    @Override
    protected void handlePropertyChange(PropertyChangeEvent event) {
    }

    @Override
    protected void doUnconfigureViewer() {
    }

    protected void setAutoActivationTriggers(ContentAssistant assistant, IPreferenceStore store) {
        LangContentAssistProcessor jcp = this.getLangContentAssistProcessor(assistant);
        if (jcp == null) {
            return;
        }
        String triggers = "";
        if (((Boolean)AUTO_ACTIVATE__DotTrigger.get()).booleanValue()) {
            triggers = String.valueOf(triggers) + ".";
        }
        if (((Boolean)AUTO_ACTIVATE__DoubleColonTrigger.get()).booleanValue()) {
            triggers = String.valueOf(triggers) + ":";
        }
        if (((Boolean)AUTO_ACTIVATE__AlphaNumericTrigger.get()).booleanValue()) {
            triggers = String.valueOf(triggers) + "abcdefghijklmnopqrstuvwxyz";
            triggers = String.valueOf(triggers) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        }
        if (triggers != null) {
            jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
    }

    protected LangContentAssistProcessor getLangContentAssistProcessor(ContentAssistant assistant) {
        IContentAssistProcessor cap = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (cap instanceof LangContentAssistProcessor) {
            return (LangContentAssistProcessor)cap;
        }
        return null;
    }
}

