/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.coloring;

import melnorme.util.swt.jface.text.ColorManager2;
import melnorme.utilbox.core.Assert;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class TextStyling {
    public final boolean isEnabled;
    public final RGB rgb;
    public final boolean isBold;
    public final boolean isItalic;
    public final boolean isStrikethrough;
    public final boolean isUnderline;

    public TextStyling(RGB rgb) {
        this(rgb, false, false);
    }

    public TextStyling(RGB rgb, boolean bold, boolean italic) {
        this.isEnabled = true;
        this.rgb = (RGB)Assert.AssertNamespace.assertNotNull((Object)rgb);
        this.isBold = bold;
        this.isItalic = italic;
        this.isStrikethrough = false;
        this.isUnderline = false;
    }

    public TextStyling(boolean isEnabled, RGB rgb, boolean isBold, boolean isItalic, boolean isStrikethrough, boolean isUnderline) {
        this.isEnabled = isEnabled;
        this.rgb = (RGB)Assert.AssertNamespace.assertNotNull((Object)rgb);
        this.isBold = isBold;
        this.isItalic = isItalic;
        this.isStrikethrough = isStrikethrough;
        this.isUnderline = isUnderline;
    }

    public TextStyling(TextStylingData data) {
        this(data.isEnabled, data.rgb, data.isBold, data.isItalic, data.isStrikethrough, data.isUnderline);
    }

    public TextStylingData getData() {
        TextStylingData data = new TextStylingData();
        data.isEnabled = this.isEnabled;
        data.rgb = this.rgb;
        data.isBold = this.isBold;
        data.isItalic = this.isItalic;
        data.isStrikethrough = this.isStrikethrough;
        data.isUnderline = this.isUnderline;
        return data;
    }

    public TextAttribute getTextAttribute(ColorManager2 colorManager) {
        Color color = colorManager.getColor(this.rgb);
        return TextStyling.createTextAttribute(color, this.isBold, this.isItalic, this.isStrikethrough, this.isUnderline);
    }

    public static TextAttribute createTextAttribute(Color color, boolean isBold, boolean isItalic, boolean isStrikethrough, boolean isUnderline) {
        int style = 0;
        style |= isBold ? 1 : 0;
        style |= isItalic ? 2 : 0;
        style |= isStrikethrough ? 0x20000000 : 0;
        return new TextAttribute(color, null, style |= isUnderline ? 0x40000000 : 0);
    }

    public static class TextStylingData {
        public boolean isEnabled;
        public RGB rgb;
        public boolean isBold;
        public boolean isItalic;
        public boolean isStrikethrough;
        public boolean isUnderline;
    }
}

