/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text.coloring;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.text.LangDocumentPartitionerSetup;
import melnorme.lang.ide.ui.EditorSettings_Actual;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.ThemeHelper;
import melnorme.lang.ide.ui.editor.LangSourceViewer;
import melnorme.lang.ide.ui.preferences.PreferencesMessages;
import melnorme.lang.ide.ui.preferences.common.AbstractPreferencesBlock2;
import melnorme.lang.ide.ui.preferences.common.IPreferencesEditor;
import melnorme.lang.ide.ui.preferences.common.PreferencesPageContext;
import melnorme.lang.ide.ui.text.SimpleSourceViewerConfiguration;
import melnorme.lang.ide.ui.text.coloring.StylingPreferences;
import melnorme.lang.ide.ui.text.coloring.TextStyling;
import melnorme.lang.ide.ui.text.coloring.ThemedTextStylingPreference;
import melnorme.lang.ide.ui.utils.ControlUtils;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.components.fields.CheckBoxField;
import melnorme.util.swt.components.fields.ColorField;
import melnorme.util.swt.jface.ElementContentProvider2;
import melnorme.util.swt.jface.LabeledTreeElement;
import melnorme.util.swt.jface.TreeViewerExt;
import melnorme.util.swt.jface.text.ColorManager2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.FieldValueListener;
import melnorme.utilbox.fields.IField;
import melnorme.utilbox.misc.StreamUtil;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.tree.IElement;
import melnorme.utilbox.tree.SimpleTreeElement;
import melnorme.utilbox.tree.TreeVisitor;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.osgi.service.event.Event;

public abstract class AbstractSourceColoringConfigurationBlock
extends AbstractPreferencesBlock2 {
    protected final SourceColoringListRoot coloringOptionsList;
    protected final StylingPreferences.OverlayStylingPreferences overlayStylingPrefs = new StylingPreferences.OverlayStylingPreferences(EditorSettings_Actual.getStylingPreferences());
    protected TreeViewerExt treeViewer;
    protected CheckBoxField enableField;
    protected ColorField colorField;
    protected CheckBoxField boldCheckboxField;
    protected CheckBoxField italicCheckboxField;
    protected CheckBoxField striketroughCheckboxField;
    protected CheckBoxField underlineCheckboxField;

    public AbstractSourceColoringConfigurationBlock(PreferencesPageContext prefContext) {
        super(prefContext);
        this.coloringOptionsList = new SourceColoringListRoot();
        this.visitColoringItems(item -> prefContext.addPrefElement((IPreferencesEditor)item));
        prefContext.addPrefElement(new IPreferencesEditor(){

            @Override
            public void loadDefaults() {
                AbstractSourceColoringConfigurationBlock.this.updateWidgetFromInput();
            }

            @Override
            public void doSaveSettings() {
            }
        });
    }

    protected void visitColoringItems(final Consumer<SourceColoringElement> consumer) {
        new TreeVisitor(){

            protected boolean enterNode(IElement node) {
                if (SourceColoringElement.class.isInstance(node)) {
                    SourceColoringElement item = (SourceColoringElement)node;
                    consumer.accept(item);
                }
                return true;
            }
        }.traverse((IElement)this.coloringOptionsList);
    }

    protected abstract LabeledTreeElement[] createTreeElements();

    @Override
    public int getPreferredLayoutColumns() {
        return 1;
    }

    @Override
    protected void createContents(Composite topControl) {
        PixelConverter pc = new PixelConverter((Control)topControl);
        Link openPrefsLink = ControlUtils.createOpenPreferencesDialogLinkedText(topControl, PreferencesMessages.DLTKEditorColoringConfigurationBlock_link);
        openPrefsLink.setLayoutData((Object)AbstractSourceColoringConfigurationBlock.gdfFillDefaults().hint(pc.convertWidthInCharsToPixels(50), -1).create());
        ControlUtils.createHorizontalSpacer(topControl, 1, pc);
        SWTFactoryUtil.createLabel(topControl, 16384, PreferencesMessages.DLTKEditorPreferencePage_coloring_element, AbstractSourceColoringConfigurationBlock.gdfFillDefaults().create());
        Composite editorComposite = SWTFactoryUtil.createComposite(topControl);
        editorComposite.setLayoutData((Object)AbstractSourceColoringConfigurationBlock.gdfFillDefaults().grab(true, false).create());
        editorComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).create());
        this.treeViewer = new TreeViewerExt(editorComposite, 2052);
        this.treeViewer.setContentProvider((IContentProvider)new ElementContentProvider2());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabeledTreeElement.LabeledTreeElementLabelProvider());
        this.treeViewer.getTree().setLayoutData((Object)AbstractSourceColoringConfigurationBlock.gdfFillDefaults().hint(pc.convertWidthInCharsToPixels(40), pc.convertHeightInCharsToPixels(10)).create());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractSourceColoringConfigurationBlock.this.handleAppearanceColorListSelectionChanged();
            }
        });
        this.treeViewer.setInput((Object)this.coloringOptionsList);
        this.treeViewer.setExpandedElements(this.coloringOptionsList.getChildren());
        Composite itemEditorComposite = new Composite(editorComposite, 0);
        itemEditorComposite.setLayoutData((Object)AbstractSourceColoringConfigurationBlock.gdfFillDefaults().create());
        itemEditorComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().extendedMargins(5, 20, 5, 5).create());
        this.enableField = new CheckBoxField(PreferencesMessages.DLTKEditorPreferencePage_enable);
        this.enableField.createComponent(itemEditorComposite, AbstractSourceColoringConfigurationBlock.gdfFillDefaults().create());
        this.colorField = new ColorField(PreferencesMessages.DLTKEditorPreferencePage_color);
        this.colorField.createComponent(itemEditorComposite, AbstractSourceColoringConfigurationBlock.gdfFillDefaults().indent(20, 0).create());
        this.boldCheckboxField = new CheckBoxField(PreferencesMessages.DLTKEditorPreferencePage_bold);
        this.boldCheckboxField.createComponent(itemEditorComposite, AbstractSourceColoringConfigurationBlock.gdfFillDefaults().indent(20, 0).create());
        this.italicCheckboxField = new CheckBoxField(PreferencesMessages.DLTKEditorPreferencePage_italic);
        this.italicCheckboxField.createComponent(itemEditorComposite, AbstractSourceColoringConfigurationBlock.gdfFillDefaults().indent(20, 0).create());
        this.striketroughCheckboxField = new CheckBoxField(PreferencesMessages.DLTKEditorPreferencePage_strikethrough);
        this.striketroughCheckboxField.createComponent(itemEditorComposite, AbstractSourceColoringConfigurationBlock.gdfFillDefaults().indent(20, 0).create());
        this.underlineCheckboxField = new CheckBoxField(PreferencesMessages.DLTKEditorPreferencePage_underline);
        this.underlineCheckboxField.createComponent(itemEditorComposite, AbstractSourceColoringConfigurationBlock.gdfFillDefaults().indent(20, 0).create());
        this.enableField.addChangeListener(new ChangeStylingField(this){

            @Override
            protected void changeStylingValue(TextStyling.TextStylingData data) {
                data.isEnabled = enableField.getBooleanFieldValue();
                this.setColoringEditorControlsEnabled(data.isEnabled);
            }
        });
        this.colorField.addChangeListener(new ChangeStylingField(this){

            @Override
            protected void changeStylingValue(TextStyling.TextStylingData data) {
                data.rgb = (RGB)colorField.getFieldValue();
            }
        });
        this.boldCheckboxField.addChangeListener(new ChangeStylingField(this){

            @Override
            protected void changeStylingValue(TextStyling.TextStylingData data) {
                data.isBold = boldCheckboxField.getBooleanFieldValue();
            }
        });
        this.italicCheckboxField.addChangeListener(new ChangeStylingField(this){

            @Override
            protected void changeStylingValue(TextStyling.TextStylingData data) {
                data.isItalic = italicCheckboxField.getBooleanFieldValue();
            }
        });
        this.striketroughCheckboxField.addChangeListener(new ChangeStylingField(this){

            @Override
            protected void changeStylingValue(TextStyling.TextStylingData data) {
                data.isStrikethrough = striketroughCheckboxField.getBooleanFieldValue();
            }
        });
        this.underlineCheckboxField.addChangeListener(new ChangeStylingField(this){

            @Override
            protected void changeStylingValue(TextStyling.TextStylingData data) {
                data.isUnderline = underlineCheckboxField.getBooleanFieldValue();
            }
        });
        SWTFactoryUtil.createLabel(topControl, 16384, PreferencesMessages.DLTKEditorPreferencePage_preview, AbstractSourceColoringConfigurationBlock.gdfFillDefaults().create());
        Control previewViewerControl = this.createPreviewViewer(topControl);
        previewViewerControl.setLayoutData((Object)AbstractSourceColoringConfigurationBlock.gdfFillDefaults().hint(pc.convertWidthInCharsToPixels(50), pc.convertHeightInCharsToPixels(15)).grab(true, true).create());
        final Display display = topControl.getShell().getDisplay();
        ThemeHelper.ThemeChangeListener themeChangeListener = new ThemeHelper.ThemeChangeListener(){

            public void handleEvent(Event event) {
                display.asyncExec(() -> {
                    AbstractSourceColoringConfigurationBlock.this.visitColoringItems(item -> item.loadFromPrefs());
                    AbstractSourceColoringConfigurationBlock.this.updateWidgetFromInput();
                });
            }
        };
        topControl.addDisposeListener(e -> themeChangeListener.close());
    }

    @Override
    public void updateWidgetFromInput() {
        this.handleAppearanceColorListSelectionChanged();
    }

    public SourceColoringElement getSelectedColoringItem() {
        Object element = this.treeViewer.getSelectionFirstElement();
        if (element instanceof SourceColoringElement) {
            return (SourceColoringElement)element;
        }
        return null;
    }

    protected void handleAppearanceColorListSelectionChanged() {
        SourceColoringElement selectedItem = this.getSelectedColoringItem();
        if (selectedItem == null) {
            this.enableField.setEnabled(false);
            this.setColoringEditorControlsEnabled(false);
        } else {
            this.enableField.setEnabled(false);
            this.enableField.setFieldValue(selectedItem.getWorkingValue().isEnabled);
            this.colorField.setFieldValue(selectedItem.getWorkingValue().rgb);
            this.boldCheckboxField.setFieldValue(selectedItem.getWorkingValue().isBold);
            this.italicCheckboxField.setFieldValue(selectedItem.getWorkingValue().isItalic);
            this.striketroughCheckboxField.setFieldValue(selectedItem.getWorkingValue().isStrikethrough);
            this.underlineCheckboxField.setFieldValue(selectedItem.getWorkingValue().isUnderline);
        }
    }

    protected void setColoringEditorControlsEnabled(boolean enabled) {
        this.boldCheckboxField.setEnabled(enabled);
        this.colorField.setEnabled(enabled);
        this.italicCheckboxField.setEnabled(enabled);
        this.striketroughCheckboxField.setEnabled(enabled);
        this.underlineCheckboxField.setEnabled(enabled);
    }

    protected Control createPreviewViewer(Composite topControl) {
        IPreferenceStore store = LangUIPlugin.getInstance().getCombinedPreferenceStore();
        ProjectionViewer fPreviewViewer = this.createPreviewViewer(topControl, false, 2816, store);
        fPreviewViewer.setEditable(false);
        Document document = new Document(this.getPreviewContent());
        LangDocumentPartitionerSetup.getInstance().setup((IDocument)document);
        fPreviewViewer.setDocument((IDocument)document);
        return fPreviewViewer.getControl();
    }

    protected String getPreviewContent() {
        InputStream is = this.getPreviewContentAsStream();
        try {
            return StreamUtil.readAllBytesFromStream((InputStream)is).toString(StringUtil.UTF8);
        }
        catch (IOException e) {
            LangCore.logInternalError((Throwable)e);
            return "<INTERNAL ERROR: COULD NOT READ PREVIEW FILE";
        }
    }

    protected abstract InputStream getPreviewContentAsStream();

    protected ProjectionViewer createPreviewViewer(Composite parent, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
        LangSourceViewer sourceViewer = new LangSourceViewer(parent, null, null, showAnnotationsOverview, styles);
        ColorManager2 colorManager = new ColorManager2();
        sourceViewer.addOwned(colorManager);
        SimpleSourceViewerConfiguration configuration = this.createSimpleSourceViewerConfig(store, colorManager);
        sourceViewer.configure((SourceViewerConfiguration)configuration);
        return sourceViewer;
    }

    protected SimpleSourceViewerConfiguration createSimpleSourceViewerConfig(IPreferenceStore preferenceStore, final ColorManager2 _colorManager) {
        return new SimpleSourceViewerConfiguration(preferenceStore){

            @Override
            protected ColorManager2 init_ColorManager() {
                return _colorManager;
            }

            @Override
            protected StylingPreferences init_StylePreferences() {
                return AbstractSourceColoringConfigurationBlock.this.overlayStylingPrefs;
            }
        };
    }

    protected abstract class ChangeStylingField
    implements FieldValueListener.FieldChangeListener {
        protected ChangeStylingField() {
        }

        public void fieldValueChanged() {
            IField<TextStyling> field = AbstractSourceColoringConfigurationBlock.this.getSelectedColoringItem().temporaryPref;
            TextStyling newStyling = (TextStyling)field.get();
            TextStyling.TextStylingData data = newStyling.getData();
            this.changeStylingValue(data);
            field.set((Object)new TextStyling(data));
        }

        protected abstract void changeStylingValue(TextStyling.TextStylingData var1);
    }

    public static class SourceColoringCategory
    extends LabeledTreeElement {
        public SourceColoringCategory(String labelText, IElement[] children) {
            super(null, children, labelText);
        }
    }

    public class SourceColoringElement
    extends LabeledTreeElement
    implements IPreferencesEditor {
        protected final ThemedTextStylingPreference stylingPref;
        protected final String prefId;
        protected final IField<TextStyling> temporaryPref;

        public SourceColoringElement(String labelText, ThemedTextStylingPreference stylingPref) {
            super(null, null, labelText);
            this.stylingPref = stylingPref;
            this.prefId = stylingPref.getPrefId();
            this.temporaryPref = AbstractSourceColoringConfigurationBlock.this.overlayStylingPrefs.get(this.prefId);
            this.loadFromPrefs();
        }

        public void loadFromPrefs() {
            this.temporaryPref.set((Object)this.stylingPref.getFieldValue());
        }

        public TextStyling getWorkingValue() {
            return (TextStyling)this.temporaryPref.get();
        }

        @Override
        public void loadDefaults() {
            this.temporaryPref.set((Object)this.stylingPref.getDefaultValue());
        }

        @Override
        public void doSaveSettings() throws CommonException {
            this.stylingPref.setInstanceScopeValue((TextStyling)this.temporaryPref.get());
        }
    }

    public class SourceColoringListRoot
    extends SimpleTreeElement {
        public SourceColoringListRoot() {
            super(null, (IElement[])AbstractSourceColoringConfigurationBlock.this.createTreeElements());
            Assert.AssertNamespace.assertTrue((this.children != null ? 1 : 0) != 0);
        }
    }
}

