/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text;

import melnorme.lang.ide.core.TextSettings_Actual;
import melnorme.lang.ide.ui.CodeFormatterConstants;
import melnorme.lang.ide.ui.EditorSettings_Actual;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.editor.ProjectionViewerExt;
import melnorme.lang.ide.ui.editor.ViewerColorUpdater;
import melnorme.lang.ide.ui.text.AbstractLangScanner;
import melnorme.lang.ide.ui.text.coloring.StylingPreferences;
import melnorme.lang.ide.ui.text.coloring.TokenRegistry;
import melnorme.util.swt.jface.text.ColorManager2;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.ArrayUtil;
import melnorme.utilbox.ownership.IDisposable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public abstract class AbstractSimpleLangSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    protected final IPreferenceStore preferenceStore;
    protected final ColorManager2 colorManager;
    protected final StylingPreferences stylingPrefs;

    public AbstractSimpleLangSourceViewerConfiguration(IPreferenceStore preferenceStore) {
        super((IPreferenceStore)Assert.AssertNamespace.assertNotNull((Object)preferenceStore));
        this.preferenceStore = preferenceStore;
        this.colorManager = (ColorManager2)Assert.AssertNamespace.assertNotNull((Object)this.init_ColorManager());
        this.stylingPrefs = (StylingPreferences)Assert.AssertNamespace.assertNotNull((Object)this.init_StylePreferences());
    }

    protected ColorManager2 init_ColorManager() {
        return LangUIPlugin.getInstance().getColorManager();
    }

    protected StylingPreferences init_StylePreferences() {
        return EditorSettings_Actual.getStylingPreferences();
    }

    protected final ColorManager2 getColorManager() {
        return this.colorManager;
    }

    public final IPreferenceStore getPreferenceStore() {
        Assert.AssertNamespace.assertTrue((this.fPreferenceStore == this.preferenceStore ? 1 : 0) != 0);
        return this.preferenceStore;
    }

    public void handlePropertyChange(PropertyChangeEvent event, IPreferenceStore prefStore, SourceViewer sourceViewer) {
        Assert.AssertNamespace.assertTrue((prefStore == this.getPreferenceStore() ? 1 : 0) != 0);
        String property = event.getProperty();
        this.updateIndentationSettings(sourceViewer, property);
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "___go_partioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return (String[])ArrayUtil.map((Object[])this.getPartitionTypes(), obj -> obj.getId(), String.class);
    }

    public TextSettings_Actual.LangPartitionTypes[] getPartitionTypes() {
        return TextSettings_Actual.LangPartitionTypes.values();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = this.createPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.setupPresentationReconciler(reconciler, sourceViewer);
        return reconciler;
    }

    protected PresentationReconciler createPresentationReconciler() {
        return new PresentationReconciler();
    }

    protected void setupPresentationReconciler(PresentationReconciler reconciler, final ISourceViewer sourceViewer) {
        Assert.AssertNamespace.assertTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        TokenRegistry tokenRegistry = new TokenRegistry(this.colorManager, this.stylingPrefs){

            @Override
            protected void handleTokenModified(Token token) {
                sourceViewer.invalidateTextPresentation();
            }
        };
        this.addConfigurationScopedOwned(sourceViewer, (IDisposable)tokenRegistry);
        ArrayList2 scanners = new ArrayList2();
        TextSettings_Actual.LangPartitionTypes[] langPartitionTypesArray = this.getPartitionTypes();
        int n = langPartitionTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextSettings_Actual.LangPartitionTypes partitionType = langPartitionTypesArray[n2];
            String contentType = partitionType.getId();
            AbstractLangScanner scanner = this.createScannerFor(Display.getCurrent(), partitionType, tokenRegistry);
            scanners.add((Object)scanner);
            DefaultDamagerRepairer dr = this.getDamagerRepairer(scanner, contentType);
            reconciler.setDamager((IPresentationDamager)dr, contentType);
            reconciler.setRepairer((IPresentationRepairer)dr, contentType);
            ++n2;
        }
    }

    protected DefaultDamagerRepairer getDamagerRepairer(AbstractLangScanner scanner, String contentType) {
        return new DefaultDamagerRepairer((ITokenScanner)scanner);
    }

    protected void addConfigurationScopedOwned(ISourceViewer sourceViewer, IDisposable tokenStore) {
        if (sourceViewer instanceof ProjectionViewerExt) {
            ProjectionViewerExt viewerExt = (ProjectionViewerExt)sourceViewer;
            viewerExt.addConfigurationOwned(tokenStore);
        } else {
            sourceViewer.getTextWidget().addDisposeListener(e -> tokenStore.dispose());
        }
    }

    protected abstract AbstractLangScanner createScannerFor(Display var1, TextSettings_Actual.LangPartitionTypes var2, TokenRegistry var3);

    public String getFontPropertyPreferenceKey() {
        return "org.eclipse.jface.textfont";
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.fPreferenceStore.getInt(CodeFormatterConstants.FORMATTER_TAB_SIZE.key);
    }

    protected void updateIndentationSettings(SourceViewer sourceViewer, String property) {
        if (CodeFormatterConstants.FORMATTER_TAB_SIZE.key.equals(property)) {
            StyledText textWidget = sourceViewer.getTextWidget();
            int tabWidth = this.getTabWidth((ISourceViewer)sourceViewer);
            textWidget.setTabs(tabWidth);
        }
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }

    protected IInformationControlCreator getInformationControl_ContentAsssist(final String statusFieldText) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, statusFieldText);
            }
        };
    }

    public static final String getAdditionalInfoAffordanceString() {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (!store.getBoolean("showTextHoverAffordance")) {
            return null;
        }
        return "Press 'Tab' from proposal table or click for focus";
    }

    public static ContentAssistant setupSimpleContentAssistant(IContentAssistProcessor cap, String[] contentTypes) {
        ContentAssistant ca = new ContentAssistant();
        ca.enableAutoActivation(true);
        ca.enableAutoInsert(true);
        String[] stringArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String partitionType = stringArray[n2];
            ca.setContentAssistProcessor(cap, partitionType);
            ++n2;
        }
        return ca;
    }

    public void configureViewer(ProjectionViewerExt sourceViewer) {
        StyledText textWidget = sourceViewer.getTextWidget();
        if (textWidget != null) {
            textWidget.setFont(JFaceResources.getFont((String)this.getFontPropertyPreferenceKey()));
        }
        new ViewerColorUpdater(this.fPreferenceStore, sourceViewer).configureViewer();
    }
}

