/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.text;

import melnorme.lang.ide.core.text.BufferedRuleBasedScannerExt;
import melnorme.lang.ide.core.text.CharacterScanner_ReaderHelper;
import melnorme.lang.ide.ui.text.coloring.ILangTokenScanner;
import melnorme.lang.ide.ui.text.coloring.ThemedTextStylingPreference;
import melnorme.lang.ide.ui.text.coloring.TokenRegistry;
import melnorme.lang.tooling.parser.lexer.ILexingRule2;
import melnorme.lang.utils.parse.ICharacterReader;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public abstract class AbstractLangScanner
extends BufferedRuleBasedScannerExt
implements ILangTokenScanner {
    protected final TokenRegistry tokenRegistry;

    public AbstractLangScanner(TokenRegistry tokenRegistry) {
        this.tokenRegistry = (TokenRegistry)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)tokenRegistry)));
        ArrayList2 arrayList2 = new ArrayList2();
        this.initRules((ArrayList2<IRule>)arrayList2);
        this.setRules((IRule[])arrayList2.toArray(IRule.class));
    }

    public IToken getToken(ThemedTextStylingPreference stylingPref) {
        return this.tokenRegistry.getToken(stylingPref);
    }

    protected abstract void initRules(ArrayList2<IRule> var1);

    public IToken nextToken() {
        return this.doNextToken();
    }

    protected IToken doNextToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        int i = 0;
        while (i < this.fRules.length) {
            this.fOffset = this.fTokenOffset;
            IToken token = this.fRules[i].evaluate((ICharacterScanner)this);
            if (!token.isUndefined()) {
                return token;
            }
            ++i;
        }
        if (this.read() == -1) {
            return Token.EOF;
        }
        return this.fDefaultReturnToken;
    }

    public static class JavaWordDetector
    implements IWordDetector {
        public boolean isWordPart(char character) {
            return Character.isJavaIdentifierPart(character);
        }

        public boolean isWordStart(char character) {
            return Character.isJavaIdentifierStart(character);
        }
    }

    public static class LangWhitespaceDetector
    implements IWhitespaceDetector {
        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }

    public class LexingRule_RuleAdapter
    implements IRule {
        protected final ILexingRule2<IToken> codeLexerRule;

        public LexingRule_RuleAdapter(ILexingRule2<IToken> codeLexerRule) {
            this.codeLexerRule = codeLexerRule;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            AbstractLangScanner langScanner = AbstractLangScanner.this;
            Assert.AssertNamespace.assertTrue((scanner == langScanner ? 1 : 0) != 0);
            CharacterScanner_ReaderHelper readerHelper = new CharacterScanner_ReaderHelper((BufferedRuleBasedScannerExt)langScanner);
            IToken token = (IToken)this.codeLexerRule.evaluateToken((ICharacterReader)readerHelper);
            if (token == null) {
                return Token.UNDEFINED;
            }
            return token;
        }
    }
}

