/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.templates;

import java.io.IOException;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.ui.EditorSettings_Actual;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.utilbox.core.CoreUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public class TemplateRegistry {
    private static final String TEMPLATES_PREF_KEY = "LangTemplatesStore";
    protected ContextTypeRegistry contextTypeRegistry;
    protected TemplateStore store;

    public IPreferenceStore getPreferenceStore() {
        return LangUIPlugin.getInstance().getPreferenceStore();
    }

    protected String[] getRegisteredContextTypeIds() {
        return (String[])CoreUtil.array((Object[])new String[]{EditorSettings_Actual.TEMPLATE_CONTEXT_TYPE_ID});
    }

    public TemplateStore getTemplateStore() {
        if (this.store == null) {
            this.store = new ContributionTemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), TEMPLATES_PREF_KEY);
            try {
                this.store.load();
            }
            catch (IOException e) {
                LangCore.logError((String)"Could not load template store.", (Throwable)e);
            }
        }
        return this.store;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.contextTypeRegistry == null) {
            this.contextTypeRegistry = this.createContributionContextTypeRegistry();
        }
        return this.contextTypeRegistry;
    }

    protected ContextTypeRegistry createContributionContextTypeRegistry() {
        ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
        String[] stringArray = this.getRegisteredContextTypeIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            registry.addContextType(id);
            ++n2;
        }
        return registry;
    }

    public TemplateContextType getContextType(String contextTypeId) {
        return this.getContextTypeRegistry().getContextType(contextTypeId);
    }
}

