/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.templates;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.ui.templates.LangContext;
import melnorme.lang.ide.ui.templates.TemplateInformationControlCreator;
import melnorme.lang.ide.ui.utils.WorkbenchUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public class LangTemplateProposal
extends TemplateProposal
implements ICompletionProposalExtension4,
ICompletionProposalExtension6 {
    protected StyledString styledDisplayString;

    public LangTemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
        super(template, context, region, image);
    }

    public LangTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
    }

    public String getDisplayString() {
        return this.getStyledDisplayString().getString();
    }

    public StyledString getStyledDisplayString() {
        if (this.styledDisplayString == null) {
            Template template = this.getTemplate();
            StyledString styledString = new StyledString(template.getName(), StyledString.COUNTER_STYLER);
            styledString.append(new StyledString(" - " + template.getDescription(), StyledString.QUALIFIER_STYLER));
            this.styledDisplayString = styledString;
        }
        return this.styledDisplayString;
    }

    public String getAdditionalProposalInfo() {
        if (this.getContext() instanceof LangContext) {
            LangContext context = (LangContext)this.getContext();
            try {
                return context.evaluate(this.getTemplate(), false).getString();
            }
            catch (BadLocationException | TemplateException e) {
                LangCore.logError((String)"Error evaluating template", (Throwable)e);
            }
        }
        return this.getTemplate().getPattern();
    }

    public String toString() {
        return this.getDisplayString();
    }

    public IInformationControlCreator getInformationControlCreator() {
        return LangTemplateProposal.createTemplateInformationControlCreator();
    }

    public static IInformationControlCreator createTemplateInformationControlCreator() {
        int orientation = 0x2000000;
        IEditorPart editor = WorkbenchUtils.getActiveEditor();
        if (editor instanceof IWorkbenchPartOrientation) {
            orientation = ((IWorkbenchPartOrientation)editor).getOrientation();
            orientation = orientation == 0 ? 0x2000000 : orientation;
        }
        return new TemplateInformationControlCreator(orientation);
    }

    public boolean isAutoInsertable() {
        if (this.isSelectionTemplate()) {
            return false;
        }
        return this.getTemplate().isAutoInsertable();
    }

    private boolean isSelectionTemplate() {
        DocumentTemplateContext ctx;
        return this.getContext() instanceof DocumentTemplateContext && (ctx = (DocumentTemplateContext)this.getContext()).getCompletionLength() > 0;
    }
}

