/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.templates;

import melnorme.lang.ide.core.text.LangDocumentPartitionerSetup;
import melnorme.lang.ide.ui.EditorSettings_Actual;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.editor.LangSourceViewer;
import melnorme.lang.ide.ui.text.SimpleSourceViewerConfiguration;
import melnorme.util.swt.jface.text.ColorManager2;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;

public abstract class LangTemplatePreferencePage
extends TemplatePreferencePage
implements IWorkbenchPreferencePage {
    public LangTemplatePreferencePage() {
        this.setPreferenceStore(LangUIPlugin.getInstance().getPreferenceStore());
        this.setTemplateStore(LangUIPlugin.getTemplateRegistry().getTemplateStore());
        this.setContextTypeRegistry(LangUIPlugin.getTemplateRegistry().getContextTypeRegistry());
        this.setDescription("&Create, edit or remove snippet templates:");
    }

    public void setTitle(String title) {
        super.setTitle("Code Snippets");
    }

    public static ColorManager2 getColorManager() {
        return LangUIPlugin.getInstance().getColorManager();
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        LangUIPlugin.flushInstanceScope();
        return ok;
    }

    protected boolean isShowFormatterSetting() {
        return false;
    }

    protected String getFormatterPreferenceKey() {
        return super.getFormatterPreferenceKey();
    }

    protected SourceViewer createViewer(Composite parent) {
        LangSourceViewer viewer = new LangSourceViewer(parent, null, null, false, 2816);
        viewer.configure(this.createPreviewerSourceViewerConfiguration());
        viewer.setEditable(false);
        viewer.setDocument(this.createViewerDocument());
        return viewer;
    }

    protected IDocument createViewerDocument() {
        Document document = new Document();
        LangDocumentPartitionerSetup.getInstance().setup((IDocument)document);
        return document;
    }

    protected SourceViewerConfiguration createPreviewerSourceViewerConfiguration() {
        return new SimpleSourceViewerConfiguration(this.getPreferenceStore());
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            Template template = data.getTemplate();
            this.getViewer().getDocument().set(template.getPattern());
        } else {
            this.getViewer().getDocument().set("");
        }
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        LangEditTemplateDialog dialog = new LangEditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.getContextTypeRegistry());
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    public static class LangEditTemplateDialog
    extends TemplatePreferencePage.EditTemplateDialog {
        public LangEditTemplateDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry) {
            super(parent, template, edit, isNameModifiable, registry);
        }

        protected SourceViewer createViewer(Composite parent) {
            LangSourceViewer viewer = new LangSourceViewer(parent, null, null, false, 2816);
            IContentAssistProcessor templateProcessor = this.getTemplateProcessor();
            Document document = new Document();
            LangDocumentPartitionerSetup.getInstance().setup((IDocument)document);
            IPreferenceStore store = LangUIPlugin.getDefault().getCombinedPreferenceStore();
            SourceViewerConfiguration configuration = EditorSettings_Actual.createTemplateEditorSourceViewerConfiguration(store, templateProcessor);
            viewer.configure(configuration);
            viewer.setEditable(true);
            viewer.setDocument((IDocument)document);
            return viewer;
        }
    }
}

