/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.templates;

import _org.eclipse.jdt.internal.corext.template.java.JavaContext;
import _org.eclipse.jdt.internal.corext.template.java.JavaFormatter;
import java.util.Collections;
import melnorme.lang.ide.core.ISourceFile;
import melnorme.lang.ide.core.text.DocumentModification;
import melnorme.lang.ide.core.text.TextSourceUtils;
import melnorme.lang.ide.ui.templates.LangTemplateContextType;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.text.edits.MalformedTreeException;

public class LangContext
extends JavaContext {
    public LangContext(LangTemplateContextType type, IDocument document, int completionOffset, int completionLength, ISourceFile compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    public LangContext(LangTemplateContextType type, IDocument document, Position completionPosition, ISourceFile compilationUnit) {
        super(type, document, completionPosition, compilationUnit);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        return this.evaluate(template, true);
    }

    public TemplateBuffer evaluate(Template template, boolean fixIndentation) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        String pattern = template.getPattern();
        TemplateBuffer buffer = translator.translate(pattern);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        if (fixIndentation) {
            String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
            JavaFormatter formatter = new JavaFormatter(delimiter){

                @Override
                protected void indent(IDocument document) throws BadLocationException, MalformedTreeException {
                    LangContext.this.simpleIndent(document);
                }
            };
            formatter.format(buffer, this);
        }
        return buffer;
    }

    protected String fixIndentation(String docString) {
        String delimeter = "\n";
        String indent = TextSourceUtils.getLineIndentForOffset((String)docString, (int)this.getStart());
        StringBuilder newContents = new StringBuilder();
        StringCharSource parser = new StringCharSource(docString);
        String start = parser.consumeUntil("\n");
        newContents.append(start);
        while (true) {
            if (!parser.tryConsume("\n")) break;
            newContents.append("\n");
            newContents.append(indent);
            String line = parser.consumeUntil("\n");
            newContents.append(line);
        }
        Assert.AssertNamespace.assertTrue((boolean)parser.lookaheadIsEOS());
        return newContents.toString();
    }

    protected void simpleIndent(IDocument document) throws BadLocationException {
        String docContents = this.getDocument().get();
        String delimeter = "\n";
        String indent = TextSourceUtils.getLineIndentForOffset((String)docContents, (int)this.getStart());
        ArrayList2 changes = new ArrayList2();
        StringCharSource parser = new StringCharSource(document.get());
        parser.consumeUntil("\n");
        while (true) {
            if (!parser.tryConsume("\n")) break;
            changes.add((Object)new DocumentModification(parser.getReadPosition(), 0, indent));
            parser.consumeUntil("\n");
        }
        Assert.AssertNamespace.assertTrue((boolean)parser.lookaheadIsEOS());
        Collections.reverse(changes);
        for (DocumentModification docMod : changes) {
            docMod.apply(document);
        }
    }
}

