/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.preferences;

import melnorme.lang.ide.ui.preferences.ColorPreference;
import melnorme.lang.ide.ui.preferences.PreferencesMessages;
import melnorme.lang.ide.ui.preferences.common.IPreferencesEditor;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.components.AbstractWidget;
import melnorme.utilbox.core.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class EditorAppearanceColorsComponent
extends AbstractWidget
implements IPreferencesEditor {
    protected final IPreferenceStore store;
    protected final EditorColorItem[] editorColorItems;
    protected List colorList;
    protected ColorSelector colorEditor;
    protected Button useSystemDefaultButton;
    protected final EditorColorItem NULL_ELEMENT = new EditorColorItem("", "", null, 0);

    public EditorAppearanceColorsComponent(IPreferenceStore store, EditorColorItem[] editorColorItems) {
        this.store = (IPreferenceStore)Assert.AssertNamespace.assertNotNull((Object)store);
        this.editorColorItems = (EditorColorItem[])Assert.AssertNamespace.assertNotNull((Object)editorColorItems);
    }

    @Override
    public void loadDefaults() {
        EditorColorItem[] editorColorItemArray = this.editorColorItems;
        int n = this.editorColorItems.length;
        int n2 = 0;
        while (n2 < n) {
            EditorColorItem editorColorItem = editorColorItemArray[n2];
            editorColorItem.loadStoreDefaults(this.store);
            ++n2;
        }
        this.handleAppearanceColorListSelectionChanged();
    }

    @Override
    public void doSaveSettings() {
        EditorColorItem[] editorColorItemArray = this.editorColorItems;
        int n = this.editorColorItems.length;
        int n2 = 0;
        while (n2 < n) {
            EditorColorItem editorColorItem = editorColorItemArray[n2];
            editorColorItem.saveToStore(this.store);
            ++n2;
        }
    }

    @Override
    public int getPreferredLayoutColumns() {
        return 1;
    }

    @Override
    public void createContents(Composite topControl) {
        PixelConverter pc = new PixelConverter((Control)topControl);
        GridData gd = GridDataFactory.swtDefaults().align(4, 0x1000000).span(2, 1).create();
        gd.heightHint = pc.convertHeightInCharsToPixels(1) / 2;
        SWTFactoryUtil.createLabel(topControl, 16384, "", gd);
        SWTFactoryUtil.createLabel(topControl, 16384, PreferencesMessages.EditorPreferencePage_title1, GridDataFactory.swtDefaults().align(4, 0x1000000).span(2, 1).create());
        Composite editorComposite = new Composite(topControl, 0);
        editorComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).create());
        editorComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).span(2, 1).create());
        this.colorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = pc.convertHeightInCharsToPixels(12);
        this.colorList.setLayoutData((Object)gd);
        int i = 0;
        while (i < this.editorColorItems.length) {
            this.colorList.add(this.editorColorItems[i].label);
            ++i;
        }
        this.colorList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorAppearanceColorsComponent.this.handleAppearanceColorListSelectionChanged();
            }
        });
        this.createItemEditWidgets(editorComposite);
        this.colorList.select(0);
    }

    @Override
    protected void updateWidgetFromInput() {
        EditorColorItem[] editorColorItemArray = this.editorColorItems;
        int n = this.editorColorItems.length;
        int n2 = 0;
        while (n2 < n) {
            EditorColorItem editorColorItem = editorColorItemArray[n2];
            editorColorItem.loadFromStore(this.store);
            ++n2;
        }
        this.handleAppearanceColorListSelectionChanged();
    }

    protected EditorColorItem getSelectedItem() {
        int i = this.colorList.getSelectionIndex();
        if (i == -1) {
            return this.NULL_ELEMENT;
        }
        return this.editorColorItems[i];
    }

    protected void handleAppearanceColorListSelectionChanged() {
        if (!SWTUtil.isOkToUse((Control)this.colorList)) {
            return;
        }
        EditorColorItem selectedItem = this.getSelectedItem();
        if (selectedItem != null && selectedItem != this.NULL_ELEMENT) {
            this.colorEditor.setColorValue(selectedItem.getEffectiveColor(this.colorList.getDisplay()));
            this.updateItemEditWidgets(selectedItem);
        }
    }

    protected void createItemEditWidgets(Composite editorComposite) {
        Composite itemEditorComposite = new Composite(editorComposite, 0);
        itemEditorComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        itemEditorComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).create());
        SWTFactoryUtil.createLabel(itemEditorComposite, 16384, PreferencesMessages.EditorPreferencePage_color, new GridData());
        this.colorEditor = new ColorSelector(itemEditorComposite);
        Button colorEditorButton = this.colorEditor.getButton();
        colorEditorButton.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).create());
        colorEditorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorAppearanceColorsComponent.this.getSelectedItem().color = EditorAppearanceColorsComponent.this.colorEditor.getColorValue();
            }
        });
        this.useSystemDefaultButton = new Button(itemEditorComposite, 32);
        this.useSystemDefaultButton.setText(PreferencesMessages.EditorPreferencePage_systemDefault);
        this.useSystemDefaultButton.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).span(2, 1).create());
        this.useSystemDefaultButton.setVisible(false);
        this.useSystemDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault;
                EditorAppearanceColorsComponent.this.getSelectedItem().useSystemDefault = systemDefault = EditorAppearanceColorsComponent.this.useSystemDefaultButton.getSelection();
                EditorAppearanceColorsComponent.this.colorEditor.getButton().setEnabled(!systemDefault);
            }
        });
    }

    protected void updateItemEditWidgets(EditorColorItem appearanceItem) {
        if (appearanceItem.useSystemDefaultKey == null) {
            this.useSystemDefaultButton.setVisible(false);
            this.colorEditor.getButton().setEnabled(true);
        } else {
            this.useSystemDefaultButton.setVisible(true);
            boolean useSystemDefault = appearanceItem.useSystemDefault;
            this.useSystemDefaultButton.setSelection(useSystemDefault);
            this.colorEditor.getButton().setEnabled(!useSystemDefault);
        }
    }

    public static class EditorColorItem {
        public final String label;
        public final String colorKey;
        public RGB color;
        public final String useSystemDefaultKey;
        public final int systemColor;
        public boolean useSystemDefault;

        public EditorColorItem(String name, ColorPreference colorPref) {
            this(name, colorPref.key, null, 0);
        }

        public EditorColorItem(String label, String colorKey, String systemDefaultKey, int systemColor) {
            this.label = label;
            this.colorKey = colorKey;
            this.useSystemDefaultKey = systemDefaultKey;
            this.systemColor = systemColor;
        }

        public void setValues(String colorPrefValue, boolean useSystemDefaultPrefValue) {
            this.color = StringConverter.asRGB((String)colorPrefValue, (RGB)PreferenceConverter.COLOR_DEFAULT_DEFAULT);
            this.useSystemDefault = false;
            if (this.useSystemDefaultKey != null) {
                this.useSystemDefault = useSystemDefaultPrefValue;
            }
        }

        public void loadFromStore(IPreferenceStore store) {
            String colorPrefValue = store.getString(this.colorKey);
            boolean useSystemDefaultPrefValue = this.useSystemDefaultKey == null ? false : store.getBoolean(this.useSystemDefaultKey);
            this.setValues(colorPrefValue, useSystemDefaultPrefValue);
        }

        public void loadStoreDefaults(IPreferenceStore store) {
            String colorPrefValue = store.getDefaultString(this.colorKey);
            boolean useSystemDefaultPrefValue = this.useSystemDefaultKey == null ? false : store.getDefaultBoolean(this.useSystemDefaultKey);
            this.setValues(colorPrefValue, useSystemDefaultPrefValue);
        }

        public void saveToStore(IPreferenceStore store) {
            store.setValue(this.colorKey, StringConverter.asString((RGB)this.color));
            if (this.useSystemDefaultKey != null) {
                store.setValue(this.useSystemDefaultKey, this.useSystemDefault);
            }
        }

        public RGB getEffectiveColor(Display display) {
            if (this.useSystemDefault) {
                return display.getSystemColor(this.systemColor).getRGB();
            }
            return this.color;
        }
    }
}

