/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.operations;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.ui.utils.WorkbenchUtils;
import melnorme.lang.ide.ui.utils.operations.BasicUIOperation;
import melnorme.lang.ide.ui.utils.operations.RunOperationAsJob;
import melnorme.util.swt.SWTFactory;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.ArrayUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class StartBundleDownloadOperation
extends BasicUIOperation {
    protected final ToolManager toolMgr = LangCore.getToolManager();
    protected final String downloadBundleJobName;

    public StartBundleDownloadOperation(String operationName, String downloadBundleJobName) {
        super(operationName);
        this.downloadBundleJobName = (String)Assert.AssertNamespace.assertNotNull((Object)downloadBundleJobName);
    }

    protected void startProcessUnderJob(ProcessBuilder pb, String toolLocation) {
        String cmdLineRender = DebugPlugin.renderArguments((String[])((String[])ArrayUtil.createFrom(pb.command(), String.class)), null);
        this.startProcessUnderJob(pb, cmdLineRender, toolLocation);
    }

    protected void startProcessUnderJob(ProcessBuilder pb, String cmdLineRender, String toolLocation) {
        boolean confirm = this.openIntroDialog(cmdLineRender, toolLocation);
        if (confirm) {
            this.scheduleDownloadJob(pb);
        }
    }

    protected boolean openIntroDialog(String cmdLineRender, String toolLocation) {
        Shell shell = WorkbenchUtils.getActiveWorkbenchShell();
        IntroDialog introDialog = new IntroDialog(shell, this.operationName, cmdLineRender, toolLocation);
        boolean confirm = introDialog.open() == 0;
        return confirm;
    }

    protected void scheduleDownloadJob(ProcessBuilder pb) {
        new RunOperationAsJob(this.downloadBundleJobName, pm -> {
            ILangOperationsListener_Default.IToolOperationMonitor opMonitor = this.inJob_handleOperationStart();
            ToolManager toolManager = this.toolMgr;
            toolManager.getClass();
            new ToolManager.RunToolTask(toolManager, opMonitor, pb, EclipseUtils.cm((IProgressMonitor)pm)).runProcess(null);
            Display.getDefault().asyncExec(() -> this.afterDownloadJobCompletes_inUI());
        }).schedule();
    }

    protected ILangOperationsListener_Default.IToolOperationMonitor inJob_handleOperationStart() {
        return this.toolMgr.startNewOperation(ILangOperationsListener_Default.ProcessStartKind.ENGINE_TOOLS, false, true);
    }

    protected void afterDownloadJobCompletes_inUI() {
    }

    protected static class IntroDialog
    extends IconAndMessageDialog {
        protected final String dialogTitle;
        protected final String commandLine;
        protected final String binLocation;

        public IntroDialog(Shell parentShell, String dialogTitle, String commandLine, String binLocation) {
            super(parentShell);
            this.dialogTitle = (String)Assert.AssertNamespace.assertNotNull((Object)dialogTitle);
            this.commandLine = (String)Assert.AssertNamespace.assertNotNull((Object)commandLine);
            this.binLocation = (String)Assert.AssertNamespace.assertNotNull((Object)binLocation);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.dialogTitle);
        }

        protected Image getImage() {
            return Display.getCurrent().getSystemImage(2);
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogArea = (Composite)super.createDialogArea(parent);
            SWTFactory.createLabel(dialogArea, 0, "The following process will be started in the background:");
            SWTFactory.createReadonlyText(dialogArea, this.commandLine, GridDataFactory.fillDefaults().hint(600, -1).create());
            SWTFactory.createLabel(dialogArea, 0, "The executable will be located at:");
            SWTFactory.createReadonlyText(dialogArea, this.binLocation, GridDataFactory.fillDefaults().create());
            return dialogArea;
        }
    }
}

