/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.navigator;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.project_model.view.IBundleModelElement;
import melnorme.lang.ide.ui.navigator.BuildTargetElement;
import melnorme.lang.ide.ui.navigator.BuildTargetsContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;

interface NavigatorElementsSwitcher_Default<RET> {
    default public RET switchElement(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return this.visitResource(resource);
        }
        if (element instanceof BuildTargetsContainer) {
            return this.visitBuildTargetsElement((BuildTargetsContainer)element);
        }
        if (element instanceof BuildTargetElement) {
            return this.visitBuildTarget((BuildTargetElement)element);
        }
        if (element instanceof IBundleModelElement) {
            return this.visitBundleElement((IBundleModelElement)element);
        }
        return this.visitOther2(element);
    }

    default public RET visitResource(IResource resource) {
        int type = resource.getType();
        if (type == 4) {
            return this.visitProject((IProject)resource);
        }
        if (type == 2) {
            return this.visitFolder((IFolder)resource);
        }
        if (type == 1) {
            return this.visitFile((IFile)resource);
        }
        return this.visitWorkspaceRoot((IWorkspaceRoot)resource);
    }

    default public RET visitProject(IProject project) {
        return this.visitOther2(project);
    }

    default public RET visitFolder(IFolder folder) {
        return this.visitOther2(folder);
    }

    default public RET visitFile(IFile file) {
        if (LangCore.getBundleModelManager().resourceIsManifest((IResource)file)) {
            return this.visitManifestFile(file);
        }
        return this.visitOther2(file);
    }

    default public RET visitWorkspaceRoot(IWorkspaceRoot workspaceRoot) {
        return null;
    }

    public RET visitManifestFile(IFile var1);

    public RET visitBundleElement(IBundleModelElement var1);

    public RET visitBuildTargetsElement(BuildTargetsContainer var1);

    public RET visitBuildTarget(BuildTargetElement var1);

    default public RET visitOther2(Object element) {
        return null;
    }
}

