/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.navigator;

import _org.eclipse.jdt.ui.ProblemsLabelDecorator;
import melnorme.lang.ide.core.project_model.view.BundleErrorElement;
import melnorme.lang.ide.core.project_model.view.BundleModelElementKind;
import melnorme.lang.ide.core.project_model.view.DependenciesContainer;
import melnorme.lang.ide.core.project_model.view.RawDependencyElement;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.LangUIPlugin;
import melnorme.lang.ide.ui.navigator.BuildTargetElement;
import melnorme.lang.ide.ui.navigator.BuildTargetsContainer;
import melnorme.lang.ide.ui.navigator.NavigatorElementsSwitcher;
import melnorme.lang.ide.ui.views.AbstractLangLabelProvider;
import melnorme.lang.ide.ui.views.StylerHelpers;
import melnorme.util.swt.jface.resources.CompositeImageDescriptorExt;
import melnorme.util.swt.jface.resources.DecoratedImageDescriptor;
import melnorme.util.swt.jface.resources.ImageDescriptorRegistry;
import melnorme.utilbox.collections.ArrayList2;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class LangNavigatorLabelProvider
extends AbstractLangLabelProvider {
    protected final ArrayList2<ILabelDecorator> labelDecorators = new ArrayList2();
    protected final ImageDescriptorRegistry registry;
    protected RGB ANNOTATION_FG = new RGB(120, 120, 200);

    public LangNavigatorLabelProvider() {
        this.registry = this.init_getImageRegistry();
        ProblemsLabelDecorator problemsLabelDecorator = new ProblemsLabelDecorator(this.registry);
        problemsLabelDecorator.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                LangNavigatorLabelProvider.this.fireLabelProviderChanged(event);
            }
        });
        this.labelDecorators.add((Object)problemsLabelDecorator);
    }

    protected ImageDescriptorRegistry init_getImageRegistry() {
        return LangUIPlugin.getDefault().getImageDescriptorRegistry();
    }

    public void dispose() {
        for (ILabelDecorator labelDecorator : this.labelDecorators) {
            labelDecorator.dispose();
        }
    }

    @Override
    public StyledString getStyledText(Object element) {
        return (StyledString)this.getStyledString_switcher().switchElement(element);
    }

    protected abstract DefaultGetStyledStringSwitcher getStyledString_switcher();

    protected StyledString appendBundleRef(StyledString baseString, String bundleName, String bundleVersion) {
        String bundleNameString = bundleName == null ? "" : String.valueOf(bundleName) + " ";
        String versionString = bundleVersion == null ? "?" : bundleVersion;
        String bundleRefString = " [" + bundleNameString + versionString + "]";
        return baseString.append(bundleRefString, (StyledString.Styler)StylerHelpers.fgColor(this.ANNOTATION_FG));
    }

    public Image getImage(Object element) {
        Image baseImage = this.getBaseImage(element);
        return this.decorateImage(baseImage, element);
    }

    public Image getBaseImage(Object element) {
        ImageDescriptor baseImage = (ImageDescriptor)this.getBaseImage_switcher().switchElement(element);
        if (baseImage != null) {
            return this.registry.get(baseImage);
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return this.registry.get(this.getWorkbenchImageDescriptor((IAdaptable)resource));
        }
        return null;
    }

    protected abstract DefaultGetImageSwitcher getBaseImage_switcher();

    protected ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable) {
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (workbenchAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = workbenchAdapter.getImageDescriptor((Object)adaptable);
        return descriptor;
    }

    protected Image decorateImage(Image image, Object element) {
        for (ILabelDecorator labelDecorator : this.labelDecorators) {
            image = labelDecorator.decorateImage(image, element);
        }
        return image;
    }

    public static abstract class BundleModelGetImageSwitcher
    implements BundleModelElementKind.BundleModelElementsSwitcher<ImageDescriptor> {
        public ImageDescriptor visitDepContainer(DependenciesContainer element) {
            return LangImages.NAV_Library;
        }

        public ImageDescriptor visitRawDepElement(RawDependencyElement element) {
            return LangImages.NAV_Package;
        }

        public ImageDescriptor visitErrorElement2(BundleErrorElement element) {
            return LangImages.NAV_Error;
        }
    }

    public abstract class BundleModelGetStyledStringSwitcher
    implements BundleModelElementKind.BundleModelElementsSwitcher<StyledString> {
        public StyledString visitErrorElement2(BundleErrorElement element) {
            return new StyledString(element.errorDescription);
        }

        public StyledString visitDepContainer(DependenciesContainer element) {
            return new StyledString("Dependencies");
        }

        public StyledString visitRawDepElement(RawDependencyElement element) {
            StyledString baseString = new StyledString(element.getElementName());
            LangNavigatorLabelProvider.this.appendBundleRef(baseString, null, element.getDependencyRef().getVersion());
            return baseString;
        }
    }

    public static abstract class DefaultGetImageSwitcher
    implements NavigatorElementsSwitcher<ImageDescriptor> {
        @Override
        public ImageDescriptor visitBuildTargetsElement(BuildTargetsContainer buildTargetsElement) {
            return LangImages.BUILD_TARGETS_ELEM.getDescriptor();
        }

        @Override
        public ImageDescriptor visitBuildTarget(BuildTargetElement buildTarget) {
            ImageDescriptor baseImage = LangImages.BUILD_TARGET.getDescriptor();
            boolean normalEnabled = buildTarget.getBuildTarget().isNormalBuildEnabled();
            boolean autoEnabled = buildTarget.getBuildTarget().isAutoBuildEnabled();
            if (normalEnabled && autoEnabled) {
                return new DecoratedImageDescriptor(baseImage, LangImages.OVR_BUILD_BOTH_CHECKED, CompositeImageDescriptorExt.Corner.BOTTOM_RIGHT);
            }
            if (normalEnabled) {
                return new DecoratedImageDescriptor(baseImage, LangImages.OVR_BUILD_NORMAL_CHECKED, CompositeImageDescriptorExt.Corner.BOTTOM_RIGHT);
            }
            if (autoEnabled) {
                return new DecoratedImageDescriptor(baseImage, LangImages.OVR_BUILD_AUTO_CHECKED, CompositeImageDescriptorExt.Corner.BOTTOM_RIGHT);
            }
            return baseImage;
        }

        @Override
        public ImageDescriptor visitManifestFile(IFile element) {
            return null;
        }
    }

    public static abstract class DefaultGetStyledStringSwitcher
    implements NavigatorElementsSwitcher<StyledString> {
        @Override
        public StyledString visitProject(IProject project) {
            return null;
        }

        @Override
        public StyledString visitManifestFile(IFile element) {
            return null;
        }

        @Override
        public StyledString visitBuildTargetsElement(BuildTargetsContainer buildTargetsElement) {
            return new StyledString(buildTargetsElement.getText());
        }

        @Override
        public StyledString visitBuildTarget(BuildTargetElement buildTarget) {
            return new StyledString(buildTarget.getTargetDisplayName());
        }
    }
}

