/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.navigator;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.ProjectBuildInfo;
import melnorme.lang.ide.ui.navigator.BuildTargetElement;
import melnorme.lang.ide.ui.navigator.ElementContainer;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;
import org.eclipse.core.resources.IProject;

public class BuildTargetsContainer
extends ElementContainer<BuildTargetElement> {
    protected final BuildManager buildManager = LangCore.getBuildManager();
    public final ProjectBuildInfo buildInfo;

    public BuildTargetsContainer(ProjectBuildInfo buildInfo) {
        super(BuildTargetsContainer.toBuildTargetElements(buildInfo));
        this.buildInfo = buildInfo;
    }

    protected static ArrayList2<BuildTargetElement> toBuildTargetElements(ProjectBuildInfo buildInfo) {
        IProject project = buildInfo.getProject();
        Assert.AssertNamespace.assertNotNull((Object)buildInfo);
        Assert.AssertNamespace.assertNotNull((Object)project);
        Collection2 buildTargets = buildInfo.getBuildTargets();
        return new ArrayList2().addAll(buildTargets, buildTarget -> new BuildTargetElement(project, (BuildTarget)buildTarget));
    }

    public String getText() {
        return "Build Targets";
    }

    public IProject getProject() {
        return this.buildInfo.getProject();
    }

    public BuildManager getBuildManager() {
        return this.buildManager;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BuildTargetsContainer)) {
            return false;
        }
        BuildTargetsContainer other = (BuildTargetsContainer)obj;
        return CoreUtil.areEqual((Object)this.getProject(), (Object)other.getProject());
    }

    public int hashCode() {
        return HashcodeUtil.combinedHashCode((Object[])new Object[]{this.getProject()});
    }
}

