/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.navigator;

import java.util.Collection;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.LangCore_Actual;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.ProjectBuildInfo;
import melnorme.lang.ide.core.project_model.IProjectModelListener;
import melnorme.lang.ide.core.project_model.LangBundleModel;
import melnorme.lang.ide.core.project_model.UpdateEvent;
import melnorme.lang.ide.core.project_model.view.IBundleModelElement;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.ui.navigator.BuildTargetElement;
import melnorme.lang.ide.ui.navigator.BuildTargetsContainer;
import melnorme.lang.ide.ui.navigator.NavigatorElementsSwitcher;
import melnorme.lang.tooling.bundle.AbstractBundleInfo;
import melnorme.util.swt.SWTUtil;
import melnorme.util.swt.jface.AbstractTreeContentProvider;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.CollectionUtil;
import melnorme.utilbox.ownership.IDisposable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public abstract class AbstractNavigatorContentProvider
extends AbstractTreeContentProvider
implements ICommonContentProvider {
    protected final NavigatorBundleModelListener bundleModelListener = new NavigatorBundleModelListener();
    protected final BuildModelListener buildModelListener = new BuildModelListener();

    public void saveState(IMemento aMemento) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Assert.AssertNamespace.assertTrue((boolean)(viewer instanceof StructuredViewer));
        super.inputChanged(viewer, oldInput, newInput);
    }

    protected StructuredViewer getViewer() {
        return (StructuredViewer)this.viewer;
    }

    protected BuildManager.BuildModel getBuildModel() {
        return LangCore.getBuildManager().getBuildModel();
    }

    public LangBundleModel getBundleModel() {
        return LangCore_Actual.getBundleModel();
    }

    @Override
    protected void viewerInitialized() {
        super.viewerInitialized();
        this.getBuildModel().addListener((IProjectModelListener)this.buildModelListener);
        this.getBundleModel().addListener((IProjectModelListener)this.bundleModelListener);
    }

    @Override
    public void dispose() {
        this.getBundleModel().removeListener((IProjectModelListener)this.bundleModelListener);
        this.getBuildModel().removeListener((IProjectModelListener)this.buildModelListener);
        super.dispose();
    }

    @Override
    public boolean hasChildren(Object element) {
        return (Boolean)this.hasChildren_switcher().switchElement(element);
    }

    protected abstract LangNavigatorSwitcher_HasChildren hasChildren_switcher();

    @Override
    public Object[] getChildren(Object parent) {
        return (Object[])this.getChildren_switcher().switchElement(parent);
    }

    protected abstract LangNavigatorSwitcher_GetChildren getChildren_switcher();

    protected void addBuildTargetsContainer(IProject project, ArrayList2<Object> projectChildren) {
        ProjectBuildInfo targets = LangCore.getBuildManager().getBuildInfo(project);
        if (targets != null) {
            projectChildren.add((Object)new BuildTargetsContainer(targets));
        }
    }

    public Object getParent(Object element) {
        return this.getParent_switcher().switchElement(element);
    }

    protected abstract LangNavigatorSwitcher_GetParent getParent_switcher();

    protected class BuildModelListener
    implements IProjectModelListener<ProjectBuildInfo> {
        protected BuildModelListener() {
        }

        public void notifyUpdateEvent(UpdateEvent<ProjectBuildInfo> updateEvent) {
            Display.getDefault().asyncExec(() -> AbstractNavigatorContentProvider.this.getViewer().refresh((Object)updateEvent.project));
        }
    }

    public abstract class LangNavigatorSwitcher_GetChildren
    implements NavigatorElementsSwitcher<Object[]> {
        @Override
        public Object[] visitProject(IProject project) {
            return this.getProjectChildren(project);
        }

        @Override
        public Object[] visitBundleElement(IBundleModelElement bundleElement) {
            return bundleElement.getChildren();
        }

        @Override
        public Object[] visitBuildTargetsElement(BuildTargetsContainer buildTargetsElement) {
            return buildTargetsElement.getChildren_toArray();
        }

        @Override
        public Object[] visitBuildTarget(BuildTargetElement buildTarget) {
            return null;
        }

        @Override
        public Object[] visitManifestFile(IFile element) {
            return null;
        }

        public Object[] getProjectChildren(IProject project) {
            ArrayList2 projectChildren = new ArrayList2();
            if (project.isAccessible()) {
                this.addFirstProjectChildren(project, (ArrayList2<Object>)projectChildren);
                AbstractNavigatorContentProvider.this.addBuildTargetsContainer(project, (ArrayList2<Object>)projectChildren);
                this.addProjectResourceChildren(project, (ArrayList2<Object>)projectChildren);
            }
            return projectChildren.toArray();
        }

        protected void addProjectResourceChildren(IProject project, ArrayList2<Object> projectChildren) {
            try {
                projectChildren.addAll((Collection)CollectionUtil.createArrayList((Object[])project.members()));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        public void addFirstProjectChildren(IProject project, ArrayList2<Object> projectChildren) {
        }
    }

    public static interface LangNavigatorSwitcher_GetParent
    extends NavigatorElementsSwitcher<Object> {
        @Override
        default public Object visitResource(IResource resource) {
            return resource.getParent();
        }

        @Override
        default public Object visitBundleElement(IBundleModelElement dubElement) {
            return dubElement.getParent();
        }

        @Override
        default public Object visitBuildTargetsElement(BuildTargetsContainer buildTargetsElement) {
            return buildTargetsElement.buildInfo.getProject();
        }

        @Override
        default public Object visitBuildTarget(BuildTargetElement buildTarget) {
            return buildTarget.getParent();
        }

        @Override
        default public Object visitManifestFile(IFile element) {
            throw Assert.AssertNamespace.assertFail();
        }
    }

    protected static interface LangNavigatorSwitcher_HasChildren
    extends NavigatorElementsSwitcher<Boolean> {
        @Override
        default public Boolean visitProject(IProject project) {
            return project.isAccessible();
        }

        @Override
        default public Boolean visitBundleElement(IBundleModelElement bundleElement) {
            return bundleElement.hasChildren();
        }

        @Override
        default public Boolean visitBuildTargetsElement(BuildTargetsContainer buildTargetsElement) {
            return true;
        }

        @Override
        default public Boolean visitBuildTarget(BuildTargetElement buildTarget) {
            return false;
        }

        @Override
        default public Boolean visitManifestFile(IFile element) {
            return false;
        }

        @Override
        default public Boolean visitOther2(Object element) {
            return false;
        }
    }

    public class NavigatorBundleModelListener
    implements IDisposable,
    IProjectModelListener<AbstractBundleInfo> {
        protected final ThrottleCodeJob viewerRefreshThrottleJob;

        public NavigatorBundleModelListener() {
            this.viewerRefreshThrottleJob = new ThrottleCodeJob(AbstractNavigatorContentProvider.this, 1200){

                @Override
                protected void runThrottledCode() {
                    NavigatorBundleModelListener.this.postRefreshEventToUI(this, NavigatorBundleModelListener.this.getElementsToRefresh());
                }
            };
        }

        public void notifyUpdateEvent(UpdateEvent<AbstractBundleInfo> updateEvent) {
            this.viewerRefreshThrottleJob.scheduleRefreshJob();
        }

        public void dispose() {
        }

        protected Indexable<Object> getElementsToRefresh() {
            ArrayList2 elementsToRefresh = new ArrayList2();
            for (String projectName : AbstractNavigatorContentProvider.this.getBundleModel().getModelProjects()) {
                IProject project = EclipseUtils.getWorkspaceRoot().getProject(projectName);
                elementsToRefresh.add((Object)project);
            }
            return elementsToRefresh;
        }

        protected void postRefreshEventToUI(final ThrottleCodeJob throttleCodeJob, final Indexable<Object> elementsToRefresh) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    throttleCodeJob.markRequestFinished();
                    if (SWTUtil.isOkToUse(AbstractNavigatorContentProvider.this.getViewer().getControl())) {
                        for (Object element : elementsToRefresh) {
                            AbstractNavigatorContentProvider.this.getViewer().refresh(element);
                        }
                    }
                }
            });
        }
    }

    public abstract class ThrottleCodeJob
    extends Job {
        protected final int throttleDelayMillis;
        protected long lastRequestMillis;
        protected boolean isScheduled;

        public ThrottleCodeJob(int throttleDelayMillis) {
            super("throttle job");
            this.isScheduled = false;
            this.throttleDelayMillis = throttleDelayMillis;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleRefreshJob() {
            ThrottleCodeJob throttleCodeJob = this;
            synchronized (throttleCodeJob) {
                if (this.isScheduled) {
                    return;
                }
                Assert.AssertNamespace.assertTrue((this.getState() == 0 || this.getState() == 4 ? 1 : 0) != 0);
                this.isScheduled = true;
                long runningTimeMillis = this.getRunningTimeMillis();
                long nextPeriod = this.lastRequestMillis + (long)this.throttleDelayMillis;
                long deltaToNext = nextPeriod - runningTimeMillis;
                if (deltaToNext > 0L) {
                    this.schedule(deltaToNext);
                    return;
                }
            }
            this.runThrottledCode();
        }

        protected long getRunningTimeMillis() {
            return System.nanoTime() / 1000000L;
        }

        protected final IStatus run(IProgressMonitor monitor) {
            this.runThrottledCode();
            return EclipseCore.createOkStatus((String)"ok");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markRequestFinished() {
            ThrottleCodeJob throttleCodeJob = this;
            synchronized (throttleCodeJob) {
                this.isScheduled = false;
                this.lastRequestMillis = this.getRunningTimeMillis();
            }
        }

        protected abstract void runThrottledCode();
    }
}

