/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.launch;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.launch.ILaunchConfigSerializer;
import melnorme.lang.ide.core.launch.ProjectLaunchSettings;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ProjectValidator;
import melnorme.lang.ide.ui.LangImages;
import melnorme.lang.ide.ui.LangUIMessages;
import melnorme.lang.ide.ui.fields.ProjectField;
import melnorme.lang.ide.ui.launch.AbstractLaunchConfigurationTabExt;
import melnorme.lang.ide.ui.utils.WorkbenchUtils;
import melnorme.util.swt.SWTFactoryUtil;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.CommonRunnable;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class ProjectBasedLaunchConfigurationTab
extends AbstractLaunchConfigurationTabExt {
    protected final ProjectField projectField = new LaunchTabProjectField();

    public ProjectBasedLaunchConfigurationTab() {
        this.projectField.addChangeListener(this::updateLaunchConfigurationDialog);
    }

    protected final String getProjectName() {
        return (String)this.projectField.getFieldValue();
    }

    protected IProject getValidProjectOrNull() {
        try {
            return this.getValidProject();
        }
        catch (StatusException e) {
            return null;
        }
    }

    protected IProject getValidProject() throws StatusException {
        return this.getProjectValidator().getProject(this.getProjectName());
    }

    protected ProjectValidator getProjectValidator() {
        return new ProjectValidator("com.googlecode.goclipse.core.goNature");
    }

    @Override
    protected void doValidate() throws StatusException {
        this.getValidProject();
    }

    public String getName() {
        return LangUIMessages.mainLaunchTab_title;
    }

    public Image getImage() {
        return LangImages.IMG_LAUNCHTAB_MAIN.getImage();
    }

    public void createControl(Composite parent) {
        Composite topControl = SWTFactoryUtil.createComposite(parent);
        this.setControl((Control)topControl);
        topControl.setLayout((Layout)GridLayoutFactory.swtDefaults().spacing(5, 0).create());
        this.projectField.createComponent(topControl, new GridData(768));
        this.createVerticalSpacer(topControl, 1);
        this.createCustomControls(topControl);
        this.createVerticalSpacer(topControl, 1);
    }

    protected void createCustomControls(Composite composite) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IResource contextResource = WorkbenchUtils.getContextResource();
        this.runOperation(() -> this.getDefaultProjectSettings(contextResource).saveToConfig(config, true));
    }

    protected ILaunchConfigSerializer getDefaultProjectSettings(IResource contextResource) {
        return this.getDefaultProjectLaunchSettings().initFrom(contextResource);
    }

    protected abstract ILaunchConfigSerializer getDefaultProjectLaunchSettings();

    public void initializeFrom(ILaunchConfiguration config) {
        this.runOperation(() -> this.doInitializeFrom(config));
    }

    public void doInitializeFrom(ILaunchConfiguration config) throws CommonException {
        this.initializeFrom(this.doInitializeFrom_createSettings(config));
    }

    protected abstract ProjectLaunchSettings doInitializeFrom_createSettings(ILaunchConfiguration var1) throws CommonException;

    protected void initializeFrom(ProjectLaunchSettings projectSettings) {
        this.projectField.setFieldValue(projectSettings.projectName);
    }

    public final void performApply(ILaunchConfigurationWorkingCopy config) {
        this.runOperation(() -> this.getLaunchSettingsFromTab().saveToConfig(config));
    }

    public void runOperation(CommonRunnable op) {
        try {
            op.run();
        }
        catch (CommonException e) {
            LangCore.logStatusException((StatusException)e.toStatusException(Severity.ERROR));
        }
    }

    protected abstract ProjectLaunchSettings getLaunchSettingsFromTab();

    protected class LaunchTabProjectField
    extends ProjectField {
        protected LaunchTabProjectField() {
        }

        @Override
        protected IProject[] getDialogChooseElements() throws CoreException {
            return EclipseUtils.getOpenedProjects((String)"com.googlecode.goclipse.core.goNature");
        }
    }
}

