/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.launch;

import melnorme.lang.ide.core.LangCore;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractLaunchConfigurationTabExt
extends AbstractLaunchConfigurationTab {
    protected boolean needsDialogUpdate = false;

    public static String getConfigAttribute(ILaunchConfiguration config, String key, String defaultValue) {
        try {
            return config.getAttribute(key, defaultValue);
        }
        catch (CoreException ce) {
            LangCore.logError((String)"Exception occurred reading launch configuration attribute", (Throwable)ce);
            return defaultValue;
        }
    }

    public static boolean getConfigAttribute(ILaunchConfiguration config, String key, boolean defaultValue) {
        try {
            return config.getAttribute(key, defaultValue);
        }
        catch (CoreException ce) {
            LangCore.logError((String)"Exception occurred reading launch configuration attribute", (Throwable)ce);
            return defaultValue;
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        this.setMessage(null);
        try {
            this.doValidate();
        }
        catch (StatusException se) {
            String message = se.getMessage();
            switch (se.getSeverity()) {
                case ERROR: {
                    this.setErrorMessage(message);
                    break;
                }
                case WARNING: {
                    this.setWarningMessage(message);
                    break;
                }
                case INFO: {
                    this.setMessage(message);
                }
            }
        }
        catch (CommonException e) {
            this.setErrorMessage(e.getMessage());
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
        return this.getErrorMessage() == null;
    }

    protected abstract void doValidate() throws StatusException, CommonException, CoreException;

    protected final void updateLaunchConfigurationDialog() {
        this.needsDialogUpdate = true;
        Display.getCurrent().asyncExec(() -> {
            if (this.needsDialogUpdate) {
                this.needsDialogUpdate = false;
                this.doUpdateLaunchConfigurationDialog();
            }
        });
    }

    protected void doUpdateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }
}

