/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.structure;

import melnorme.lang.ide.ui.editor.structure.AbstractContentOutlinePage;
import melnorme.lang.ide.ui.editor.structure.AbstractLangStructureEditor;
import melnorme.lang.ide.ui.editor.structure.GetUpdatedStructureUIOperation;
import melnorme.lang.ide.ui.editor.structure.StructureElementContentProvider;
import melnorme.lang.ide.ui.views.StructureElementLabelProvider;
import melnorme.lang.tooling.structure.SourceFileStructure;
import melnorme.lang.tooling.structure.StructureElement;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.FieldValueListener;
import melnorme.utilbox.ownership.IDisposable;
import melnorme.utilbox.status.Severity;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class LangOutlinePage
extends AbstractContentOutlinePage
implements IAdaptable,
IDisposable {
    protected final AbstractLangStructureEditor editor;
    protected final FieldValueListener.FieldChangeListener structureListener = () -> this.updateTreeViewer();
    protected boolean updatingFromEditor = false;

    public LangOutlinePage(AbstractLangStructureEditor editor) {
        this.editor = editor;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)this.createContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)StructureElementLabelProvider.createLangLabelProvider());
        this.customizeCreateControl();
        this.editor.getStructureField().registerChangeListener(false, this.structureListener);
        this.editor.getSelectedElementField().registerChangeListener(false, this.structureListener);
        this.updateTreeViewer();
    }

    protected StructureElementContentProvider createContentProvider() {
        return new StructureElementContentProvider();
    }

    protected void customizeCreateControl() {
    }

    @Override
    public void dispose() {
        this.editor.getSelectedElementField().removeListener((FieldValueListener)this.structureListener);
        this.editor.getStructureField().removeListener((FieldValueListener)this.structureListener);
        super.dispose();
    }

    protected void updateTreeViewer() {
        SourceFileStructure structure;
        if (this.getTreeViewer() == null) {
            return;
        }
        try {
            structure = this.editor.getSourceStructure();
        }
        catch (CommonException e) {
            this.statusWidget.setStatusMessage(Severity.ERROR, e.getMultiLineRender());
            return;
        }
        if (this.getTreeViewer().getInput() != structure) {
            this.statusWidget.setStatusMessage(null);
            this.getTreeViewer().setInput((Object)structure);
            this.getTreeViewer().refresh();
        }
        this.updateSelectionFromEditor();
    }

    protected void updateSelectionFromEditor() {
        StructuredSelection newSelection = this.editor.getSelectedElementAsStructureSelection();
        try {
            this.updatingFromEditor = true;
            this.getTreeViewer().setSelection((ISelection)newSelection, true);
        }
        finally {
            this.updatingFromEditor = false;
        }
    }

    @Override
    protected void treeViewerPostSelectionChanged(SelectionChangedEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (firstElement instanceof StructureElement) {
            StructureElement structureElement = (StructureElement)firstElement;
            if (!this.updatingFromEditor) {
                this.editor.setElementSelection(structureElement);
            }
        }
        super.treeViewerPostSelectionChanged(event);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IShowInTarget.class) {
            return (T)this.getShowInTarget();
        }
        return null;
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext context) {
                StructureElement structureElement = LangOutlinePage.this.getStructureElementFor(context.getSelection());
                if (structureElement != null) {
                    LangOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)structureElement));
                    return true;
                }
                return false;
            }
        };
    }

    public StructureElement getStructureElementFor(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            return GetUpdatedStructureUIOperation.run_GetUpdatedStructureElementAt(this.editor, textSelection.getOffset());
        }
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof StructureElement) {
            return (StructureElement)structuredSelection.getFirstElement();
        }
        return null;
    }
}

