/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.structure;

import java.util.Optional;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.engine.SourceModelManager;
import melnorme.lang.ide.core.text.ISourceBufferExt;
import melnorme.lang.ide.ui.editor.EditorSourceBuffer;
import melnorme.lang.ide.ui.editor.structure.AbstractLangStructureEditor;
import melnorme.lang.ide.ui.utils.operations.CalculateValueUIOperation;
import melnorme.lang.tooling.LocationKey;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.structure.SourceFileStructure;
import melnorme.lang.tooling.structure.StructureElement;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.CommonResult;
import melnorme.utilbox.misc.Location;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;

public class GetUpdatedStructureUIOperation
extends CalculateValueUIOperation<SourceFileStructure> {
    protected final SourceModelManager modelManager;
    protected final LocationKey locationKey;
    protected final IDocument document;
    protected SourceModelManager.StructureInfo structureInfo;

    public GetUpdatedStructureUIOperation(LocationKey locKey, IDocument document) {
        this(LangCore.getSourceModelManager(), locKey, document);
    }

    public GetUpdatedStructureUIOperation(SourceModelManager modelManager, LocationKey locKey, IDocument document) {
        super("Awaiting Structure Calculation");
        this.modelManager = (SourceModelManager)Assert.AssertNamespace.assertNotNull((Object)modelManager);
        this.locationKey = (LocationKey)Assert.AssertNamespace.assertNotNull((Object)locKey);
        this.document = (IDocument)Assert.AssertNamespace.assertNotNull((Object)document);
    }

    @Override
    public void doExecute() throws CommonException, OperationCancellation {
        SourceModelManager.StructureModelRegistration registration = this.modelManager.connectStructureUpdates(this.locationKey, this.document, __ -> {});
        this.structureInfo = registration.structureInfo;
        try {
            super.doExecute();
        }
        finally {
            registration.dispose();
        }
    }

    @Override
    protected void executeBackgroundOperation() throws CommonException, OperationCancellation {
        if (!this.structureInfo.isStale()) {
            CommonResult structureResult = this.structureInfo.getStoredData();
            structureResult.isException();
            this.result = (SourceFileStructure)structureResult.get();
            return;
        }
        super.executeBackgroundOperation();
    }

    @Override
    protected SourceFileStructure doBackgroundValueComputation(IOperationMonitor om) throws OperationCancellation, CommonException {
        return (SourceFileStructure)((CommonResult)this.structureInfo.awaitUpdatedData(om)).get();
    }

    @Override
    protected void handleComputationResult(SourceFileStructure result) throws CommonException {
        if (result == null) {
            throw new CommonException("Could not retrieve source file structure for: " + this.structureInfo.getKey2().getLabel());
        }
    }

    public static SourceFileStructure run_GetUpdatedStructure_UserOperation(ISourceBufferExt sourceBuffer) {
        Optional location = sourceBuffer.getLocation_opt();
        LocationKey key = location.isPresent() ? new LocationKey((Location)location.get()) : new LocationKey(sourceBuffer.getKeyForCurrentInput(), "[Unlocated source buffer]");
        IDocument doc = sourceBuffer.getDocument();
        GetUpdatedStructureUIOperation op = new GetUpdatedStructureUIOperation(key, doc);
        return (SourceFileStructure)op.executeAndGetHandledResult();
    }

    public static SourceFileStructure run_GetUpdatedStructure(ITextEditor editor) {
        return GetUpdatedStructureUIOperation.run_GetUpdatedStructure_UserOperation(new EditorSourceBuffer(editor));
    }

    public static StructureElement run_GetUpdatedStructureElementAt(AbstractLangStructureEditor editor, int offset) {
        SourceFileStructure sourceFileStructure = GetUpdatedStructureUIOperation.run_GetUpdatedStructure((ITextEditor)editor);
        if (sourceFileStructure == null) {
            return null;
        }
        return sourceFileStructure.getStructureElementAt(offset);
    }
}

