/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.structure;

import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.editor.structure.AbstractLangStructureEditor;
import melnorme.lang.tooling.structure.ISourceFileStructure;
import melnorme.lang.tooling.structure.StructureElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorStructureUtil {
    public static void openInEditorAndReveal(Object selectedElement) throws CoreException {
        if (selectedElement instanceof StructureElement) {
            StructureElement structureElement = (StructureElement)selectedElement;
            ISourceFileStructure fileStructure = structureElement.getContainingFileStructure();
            if (fileStructure == null || fileStructure.getLocation() == null) {
                return;
            }
            IEditorInput newInput = EditorUtils.getBestEditorInputForLoc(fileStructure.getLocation());
            IEditorPart part = EditorUtils.openEditor(newInput, "com.googlecode.goclipse.editors.Editor", true);
            EditorStructureUtil.revealInEditor(part, structureElement);
        }
    }

    public static void revealInEditor(IEditorPart part, StructureElement element) {
        if (element == null || part == null) {
            return;
        }
        if (part instanceof AbstractLangStructureEditor) {
            ((AbstractLangStructureEditor)part).setElementSelection(element);
            return;
        }
        if (part instanceof ITextEditor) {
            AbstractLangStructureEditor.setElementSelection((ITextEditor)part, element);
            return;
        }
    }
}

