/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.structure;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.engine.IStructureModelListener;
import melnorme.lang.ide.core.engine.SourceModelManager;
import melnorme.lang.ide.ui.editor.AbstractLangEditor;
import melnorme.lang.ide.ui.editor.EditorSourceBuffer;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.editor.structure.LangOutlinePage;
import melnorme.lang.ide.ui.text.AbstractLangSourceViewerConfiguration;
import melnorme.lang.ide.ui.text.LangSourceViewerConfiguration;
import melnorme.lang.tooling.LocationKey;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.structure.SourceFileStructure;
import melnorme.lang.tooling.structure.StructureElement;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.core.fntypes.Result;
import melnorme.utilbox.fields.Field;
import melnorme.utilbox.misc.Location;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractLangStructureEditor
extends AbstractLangEditor {
    protected final SourceModelManager sourceModelMgr = LangCore.getSourceModelManager();
    protected final LangOutlinePage outlinePage = this.addOwned(this.init_createOutlinePage());
    protected Location editorLocation;
    protected SourceModelManager.StructureModelRegistration modelRegistration;
    protected final Field<Result<SourceFileStructure, CommonException>> structureResultField;
    protected final Field<StructureElement> selectedElementField;
    protected final IStructureModelListener structureInfoListener;
    protected final EditorSelectionChangedListener editorSelectionListener;

    public AbstractLangStructureEditor() {
        this.owned.bind(this::disconnectUpdates);
        this.structureResultField = new Field();
        this.selectedElementField = new Field();
        this.structureInfoListener = new IStructureModelListener(){

            public void dataChanged(final SourceModelManager.StructureInfo lockedStructureInfo) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).AbstractLangStructureEditor.this.modelRegistration == null || lockedStructureInfo != (this).AbstractLangStructureEditor.this.modelRegistration.structureInfo) {
                            return;
                        }
                        AbstractLangStructureEditor.this.handleEditorStructureUpdated((this).AbstractLangStructureEditor.this.modelRegistration.structureInfo);
                    }
                });
            }
        };
        this.editorSelectionListener = new EditorSelectionChangedListener();
    }

    @Override
    protected AbstractLangSourceViewerConfiguration createSourceViewerConfiguration() {
        return new LangSourceViewerConfiguration(this.getPreferenceStore(), new EditorSourceBuffer((ITextEditor)this), (ITextEditor)this);
    }

    @Override
    protected void internalDoSetInput(IEditorInput input) {
        super.internalDoSetInput(input);
        this.disconnectUpdates();
        LocationKey editorKey = AbstractLangStructureEditor.getStructureModelKeyFromEditorInput(input);
        this.editorLocation = editorKey.getLocation();
        IDocument doc = this.getDocumentProvider().getDocument((Object)input);
        this.modelRegistration = this.sourceModelMgr.connectStructureUpdates(editorKey, doc, this.structureInfoListener);
        this.handleEditorStructureUpdated(this.modelRegistration.structureInfo);
    }

    protected void disconnectUpdates() {
        if (this.modelRegistration != null) {
            this.modelRegistration.dispose();
            this.modelRegistration = null;
        }
    }

    public static LocationKey getStructureModelKeyFromEditorInput(IEditorInput input) {
        try {
            Location location = EditorUtils.getLocationFromEditorInput(input);
            return new LocationKey(location);
        }
        catch (CommonException e) {
            return new LocationKey((Object)input, input.toString());
        }
    }

    public Field<Result<SourceFileStructure, CommonException>> getStructureField() {
        return this.structureResultField;
    }

    public Result<SourceFileStructure, CommonException> getSourceStructureResult() {
        return (Result)this.getStructureField().getFieldValue();
    }

    public SourceFileStructure getSourceStructure() throws CommonException {
        return (SourceFileStructure)this.getSourceStructureResult().get();
    }

    public Field<StructureElement> getSelectedElementField() {
        return this.selectedElementField;
    }

    public StructureElement getSelectedElement() {
        return (StructureElement)this.selectedElementField.getFieldValue();
    }

    public StructuredSelection getSelectedElementAsStructureSelection() {
        StructureElement selectedElement = this.getSelectedElement();
        if (selectedElement == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)selectedElement);
    }

    protected void handleEditorStructureUpdated(SourceModelManager.StructureInfo structureInfo) {
        Assert.AssertNamespace.assertTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        this.structureResultField.setFieldValue((Object)structureInfo.getStoredData());
        this.setSelectedElementField();
    }

    protected void setSelectedElementField() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof TextSelection) {
            SourceFileStructure structure;
            TextSelection textSelection = (TextSelection)selection;
            int caretOffset = textSelection.getOffset();
            try {
                structure = this.getSourceStructure();
            }
            catch (CommonException e) {
                return;
            }
            if (structure != null) {
                StructureElement selectedElement = structure.getStructureElementAt(caretOffset);
                this.selectedElementField.setFieldValue((Object)selectedElement);
            }
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.editorSelectionListener.install((ISelectionProvider)Assert.AssertNamespace.assertNotNull((Object)this.getSourceViewer_()));
        this.owned.bind(() -> this.editorSelectionListener.uninstall((ISelectionProvider)this.getSourceViewer_()));
    }

    protected LangOutlinePage init_createOutlinePage() {
        return new LangOutlinePage(this);
    }

    public <T> T getAdapter(Class<T> requestedClass) {
        if (IContentOutlinePage.class.equals(requestedClass)) {
            LangOutlinePage outlinePage = this.outlinePage;
            return (T)((Object)outlinePage);
        }
        if (requestedClass == IShowInTargetList.class) {
            return (T)new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return (String[])CoreUtil.array((Object[])new String[]{"org.eclipse.ui.views.ContentOutline"});
                }
            };
        }
        return (T)super.getAdapter(requestedClass);
    }

    public void setElementSelection(StructureElement element) {
        if (this.getSelectedElementField().isNotifyingListeners()) {
            return;
        }
        AbstractLangStructureEditor.setElementSelection((ITextEditor)this, element);
        this.markInNavigationHistory();
    }

    public static void setElementSelection(ITextEditor editor, StructureElement element) {
        SourceRange nameSR = element.getNameSourceRange2();
        if (nameSR != null) {
            editor.selectAndReveal(nameSR.getOffset(), nameSR.getLength());
        }
    }

    protected class EditorSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        protected EditorSelectionChangedListener() {
            super((AbstractTextEditor)AbstractLangStructureEditor.this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractLangStructureEditor.this.setSelectedElementField();
        }
    }
}

