/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.hover;

import java.util.function.Supplier;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.ui.utils.operations.WorkbenchOperationExecutor;
import melnorme.lang.tooling.common.ISourceBuffer;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.toolchain.ops.AbstractToolOperation;
import melnorme.lang.tooling.toolchain.ops.ToolResponse;
import melnorme.lang.tooling.utils.HTMLHelper;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;

public abstract class AbstractDocDisplayInfoSupplier
implements Supplier<String> {
    protected final ISourceBuffer sourceBuffer;
    protected final int offset;

    public AbstractDocDisplayInfoSupplier(ISourceBuffer sourceBuffer, int offset) {
        this.sourceBuffer = (ISourceBuffer)Assert.AssertNamespace.assertNotNull((Object)sourceBuffer);
        this.offset = offset;
    }

    @Override
    public String get() {
        return new WorkbenchOperationExecutor().callInBackground(this::doGetDocumentation);
    }

    public String doGetDocumentation(IOperationMonitor om) {
        ToolResponse<String> rawDocumentationResult;
        try {
            rawDocumentationResult = this.getRawDocumentation(om, this.sourceBuffer, this.offset);
        }
        catch (CommonException ce) {
            LangCore.logStatusException((StatusException)ce.toStatusException());
            return "<b>Operation Error:</b> " + ce.getMessage() + StringUtil.asString((String)" ", (Object)ce.getCause());
        }
        catch (OperationCancellation e) {
            return null;
        }
        String rawDocumentation = (String)rawDocumentationResult.getResultData();
        String documentationInfo = rawDocumentation == null ? null : this.escapeToHTML(rawDocumentation);
        String errorMessage = rawDocumentationResult.getErrorMessage();
        if (errorMessage != null) {
            documentationInfo = documentationInfo == null ? "" : "</br> </hr>";
            Severity severity = Severity.ERROR;
            documentationInfo = String.valueOf(documentationInfo) + "<b>" + severity.getLabel() + ":</b> " + this.escapeToHTML(errorMessage);
        }
        if (documentationInfo == null) {
            return null;
        }
        return documentationInfo;
    }

    protected String escapeToHTML(String rawDocumentation) {
        return HTMLHelper.escapeToToHTML((String)rawDocumentation);
    }

    protected ToolResponse<String> getRawDocumentation(IOperationMonitor om, ISourceBuffer sourceBuffer, int offset) throws CommonException, OperationCancellation {
        AbstractToolOperation<String> findDefinitionOp = this.getFindDocOperation(sourceBuffer, offset);
        return (ToolResponse)findDefinitionOp.toResultOperation().executeOp(om);
    }

    protected abstract AbstractToolOperation<String> getFindDocOperation(ISourceBuffer var1, int var2);
}

