/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.ui.editor.actions;

import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.ui.editor.EditorUtils;
import melnorme.lang.ide.ui.editor.actions.AbstractEditorToolOperation;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.common.SourceLineColumnRange;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.lang.tooling.toolchain.ops.SourceLocation;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractOpenElementOperation
extends AbstractEditorToolOperation<SourceLocation> {
    protected final EditorUtils.OpenNewEditorMode openEditorMode;

    public AbstractOpenElementOperation(String operationName, ITextEditor editor, SourceRange range, EditorUtils.OpenNewEditorMode openEditorMode) {
        super(operationName, editor, range);
        this.openEditorMode = openEditorMode;
    }

    public int getInvocationOffset() {
        return this.getOperationOffset();
    }

    protected ToolManager getToolManager() {
        return LangCore.getToolManager();
    }

    @Override
    protected abstract SourceLocation doBackgroundToolResultComputation(IOperationMonitor var1) throws CommonException, OperationCancellation, OperationSoftFailure;

    @Override
    protected void handleResultData(SourceLocation resultData) throws CommonException {
        SourceLineColumnRange sourceRange = resultData.getSourceRange();
        EclipseUtils.run(() -> this.openEditorForLocation(resultData.getFileLocation(), sourceRange));
    }

    protected void openEditorForLocation(Location fileLoc, SourceLineColumnRange sourceRange) throws CoreException, CommonException {
        IEditorInput newInput = this.getNewEditorInput(fileLoc);
        ITextEditor newEditor = EditorUtils.openTextEditorAndSetSelection(this.editor, "com.googlecode.goclipse.editors.Editor", newInput, this.openEditorMode, null);
        IDocument doc = EditorUtils.getEditorDocument(newEditor);
        int selectionOffset = AbstractOpenElementOperation.getOffsetFrom(doc, sourceRange.line, sourceRange.column);
        EditorUtils.setEditorSelection(newEditor, new SourceRange(selectionOffset, 0));
    }

    protected IEditorInput getNewEditorInput(Location newEditorFilePath) throws CommonException {
        if (newEditorFilePath == null) {
            throw new CommonException("No path provided for new element. ");
        }
        if (CoreUtil.areEqual((Object)newEditorFilePath, (Object)this.getInputLocation())) {
            return this.editor.getEditorInput();
        }
        return EditorUtils.getBestEditorInputForLoc(newEditorFilePath);
    }

    protected static int getOffsetFrom(IDocument doc, int line_oneBased, int column_oneBased) throws CoreException {
        int lineOffset;
        try {
            lineOffset = doc.getLineOffset(line_oneBased - 1);
        }
        catch (BadLocationException e) {
            throw EclipseCore.createCoreException((String)("Invalid line number: " + line_oneBased), (Throwable)e);
        }
        return lineOffset + column_oneBased - 1;
    }
}

